/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.embedder;

import java.lang.reflect.Array;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.Queue;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineException;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.embedder.CodecEmbedder;
import org.jboss.netty.handler.codec.embedder.CodecEmbedderException;
import org.jboss.netty.handler.codec.embedder.EmbeddedChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCodecEmbedder<E>
implements CodecEmbedder<E> {
    private final Channel channel;
    private final ChannelPipeline pipeline;
    private final EmbeddedChannelSink sink = new EmbeddedChannelSink();
    final Queue<Object> productQueue = new LinkedList<Object>();

    protected AbstractCodecEmbedder(ChannelHandler ... handlers) {
        this.pipeline = new EmbeddedChannelPipeline();
        this.configurePipeline(handlers);
        this.channel = new EmbeddedChannel(this.pipeline, this.sink);
        this.fireInitialEvents();
    }

    protected AbstractCodecEmbedder(ChannelBufferFactory bufferFactory, ChannelHandler ... handlers) {
        this(handlers);
        this.getChannel().getConfig().setBufferFactory(bufferFactory);
    }

    private void fireInitialEvents() {
        Channels.fireChannelOpen(this.channel);
        Channels.fireChannelBound(this.channel, this.channel.getLocalAddress());
        Channels.fireChannelConnected(this.channel, this.channel.getRemoteAddress());
    }

    private void configurePipeline(ChannelHandler ... handlers) {
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers should contain at least one " + ChannelHandler.class.getSimpleName() + '.');
        }
        for (int i = 0; i < handlers.length; ++i) {
            ChannelHandler h2 = handlers[i];
            if (h2 == null) {
                throw new NullPointerException("handlers[" + i + ']');
            }
            this.pipeline.addLast(String.valueOf(i), handlers[i]);
        }
        this.pipeline.addLast("SINK", this.sink);
    }

    @Override
    public boolean finish() {
        Channels.close(this.channel);
        Channels.fireChannelDisconnected(this.channel);
        Channels.fireChannelUnbound(this.channel);
        Channels.fireChannelClosed(this.channel);
        return !this.productQueue.isEmpty();
    }

    protected final Channel getChannel() {
        return this.channel;
    }

    protected final boolean isEmpty() {
        return this.productQueue.isEmpty();
    }

    @Override
    public final E poll() {
        return (E)this.productQueue.poll();
    }

    @Override
    public final E peek() {
        return (E)this.productQueue.peek();
    }

    @Override
    public final Object[] pollAll() {
        int size2 = this.size();
        Object[] a = new Object[size2];
        for (int i = 0; i < size2; ++i) {
            E product2 = this.poll();
            if (product2 == null) {
                throw new ConcurrentModificationException();
            }
            a[i] = product2;
        }
        return a;
    }

    @Override
    public final <T> T[] pollAll(T[] a) {
        E product2;
        if (a == null) {
            throw new NullPointerException("a");
        }
        int size2 = this.size();
        if (a.length < size2) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size2);
        }
        int i = 0;
        while ((product2 = this.poll()) != null) {
            a[i] = product2;
            ++i;
        }
        if (a.length > size2) {
            a[size2] = null;
        }
        return a;
    }

    @Override
    public final int size() {
        return this.productQueue.size();
    }

    @Override
    public ChannelPipeline getPipeline() {
        return this.pipeline;
    }

    private static final class EmbeddedChannelPipeline
    extends DefaultChannelPipeline {
        EmbeddedChannelPipeline() {
        }

        protected void notifyHandlerException(ChannelEvent e, Throwable t) {
            while (t instanceof ChannelPipelineException && t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof CodecEmbedderException) {
                throw (CodecEmbedderException)t;
            }
            throw new CodecEmbedderException(t);
        }
    }

    private final class EmbeddedChannelSink
    implements ChannelSink,
    ChannelUpstreamHandler {
        EmbeddedChannelSink() {
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) {
            this.handleEvent(e);
        }

        public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) {
            this.handleEvent(e);
        }

        private void handleEvent(ChannelEvent e) {
            if (e instanceof MessageEvent) {
                boolean offered = AbstractCodecEmbedder.this.productQueue.offer(((MessageEvent)e).getMessage());
                assert (offered);
            } else if (e instanceof ExceptionEvent) {
                throw new CodecEmbedderException(((ExceptionEvent)e).getCause());
            }
        }

        public void exceptionCaught(ChannelPipeline pipeline, ChannelEvent e, ChannelPipelineException cause) throws Exception {
            Throwable actualCause = cause.getCause();
            if (actualCause == null) {
                actualCause = cause;
            }
            throw new CodecEmbedderException(actualCause);
        }

        public ChannelFuture execute(ChannelPipeline pipeline, Runnable task) {
            try {
                task.run();
                return Channels.succeededFuture(pipeline.getChannel());
            }
            catch (Throwable t) {
                return Channels.failedFuture(pipeline.getChannel(), t);
            }
        }
    }
}

