/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpHeaders;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.util.internal.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpChunkTrailer
implements HttpChunkTrailer {
    private final HttpHeaders trailingHeaders = new TrailingHeaders(true);

    @Override
    public boolean isLast() {
        return true;
    }

    @Override
    @Deprecated
    public void addHeader(String name2, Object value2) {
        this.trailingHeaders.add(name2, value2);
    }

    @Override
    @Deprecated
    public void setHeader(String name2, Object value2) {
        this.trailingHeaders.set(name2, value2);
    }

    @Override
    @Deprecated
    public void setHeader(String name2, Iterable<?> values2) {
        this.trailingHeaders.set(name2, values2);
    }

    @Override
    @Deprecated
    public void removeHeader(String name2) {
        this.trailingHeaders.remove(name2);
    }

    @Override
    @Deprecated
    public void clearHeaders() {
        this.trailingHeaders.clear();
    }

    @Override
    @Deprecated
    public String getHeader(String name2) {
        return this.trailingHeaders.get(name2);
    }

    @Override
    @Deprecated
    public List<String> getHeaders(String name2) {
        return this.trailingHeaders.getAll(name2);
    }

    @Override
    @Deprecated
    public List<Map.Entry<String, String>> getHeaders() {
        return this.trailingHeaders.entries();
    }

    @Override
    @Deprecated
    public boolean containsHeader(String name2) {
        return this.trailingHeaders.contains(name2);
    }

    @Override
    @Deprecated
    public Set<String> getHeaderNames() {
        return this.trailingHeaders.names();
    }

    @Override
    public ChannelBuffer getContent() {
        return ChannelBuffers.EMPTY_BUFFER;
    }

    @Override
    public void setContent(ChannelBuffer content) {
        throw new IllegalStateException("read-only");
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    private void appendHeaders(StringBuilder buf) {
        for (Map.Entry e : this.trailingHeaders()) {
            buf.append((String)e.getKey());
            buf.append(": ");
            buf.append((String)e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrailingHeaders
    extends DefaultHttpHeaders {
        TrailingHeaders(boolean validateHeaders) {
            super(validateHeaders);
        }

        @Override
        public HttpHeaders add(String name2, Object value2) {
            if (this.validate) {
                TrailingHeaders.validateName(name2);
            }
            return super.add(name2, value2);
        }

        @Override
        public HttpHeaders add(String name2, Iterable<?> values2) {
            if (this.validate) {
                TrailingHeaders.validateName(name2);
            }
            return super.add(name2, values2);
        }

        @Override
        public HttpHeaders set(String name2, Iterable<?> values2) {
            if (this.validate) {
                TrailingHeaders.validateName(name2);
            }
            return super.set(name2, values2);
        }

        @Override
        public HttpHeaders set(String name2, Object value2) {
            if (this.validate) {
                TrailingHeaders.validateName(name2);
            }
            return super.set(name2, value2);
        }

        private static void validateName(String name2) {
            if (name2.equalsIgnoreCase("Content-Length") || name2.equalsIgnoreCase("Transfer-Encoding") || name2.equalsIgnoreCase("Trailer")) {
                throw new IllegalArgumentException("prohibited trailing header: " + name2);
            }
        }
    }
}

