/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.netty.handler.codec.http.HttpHeaderDateFormat;
import org.jboss.netty.handler.codec.http.HttpHeaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpHeaders
extends HttpHeaders {
    private static final int BUCKET_SIZE = 17;
    private static final Set<String> KNOWN_NAMES = DefaultHttpHeaders.createSet(HttpHeaders.Names.class);
    private static final Set<String> KNOWN_VALUES = DefaultHttpHeaders.createSet(HttpHeaders.Values.class);
    private final HeaderEntry[] entries = new HeaderEntry[17];
    private final HeaderEntry head;
    protected final boolean validate;

    private static Set<String> createSet(Class<?> clazz) {
        Field[] fields;
        HashSet<String> set2 = new HashSet<String>();
        for (Field f2 : fields = clazz.getDeclaredFields()) {
            int m = f2.getModifiers();
            if (!Modifier.isPublic(m) || !Modifier.isStatic(m) || !Modifier.isFinal(m) || !f2.getType().isAssignableFrom(String.class)) continue;
            try {
                set2.add((String)f2.get(null));
            }
            catch (Throwable cause) {
                // empty catch block
            }
        }
        return set2;
    }

    private static int hash(String name2, boolean validate2) {
        int h2 = 0;
        for (int i = name2.length() - 1; i >= 0; --i) {
            char c = name2.charAt(i);
            if (validate2) {
                DefaultHttpHeaders.valideHeaderNameChar(c);
            }
            c = DefaultHttpHeaders.toLowerCase(c);
            h2 = 31 * h2 + c;
        }
        if (h2 > 0) {
            return h2;
        }
        if (h2 == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -h2;
    }

    private static boolean eq(String name1, String name2) {
        if (name1 == name2) {
            return true;
        }
        int nameLen = name1.length();
        if (nameLen != name2.length()) {
            return false;
        }
        for (int i = nameLen - 1; i >= 0; --i) {
            char c2;
            char c1 = name1.charAt(i);
            if (c1 == (c2 = name2.charAt(i)) || DefaultHttpHeaders.toLowerCase(c1) == DefaultHttpHeaders.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    private static char toLowerCase(char c) {
        if (c >= 'A' && c <= 'Z') {
            c = (char)(c + 32);
        }
        return c;
    }

    private static int index(int hash2) {
        return hash2 % 17;
    }

    public DefaultHttpHeaders() {
        this(true);
    }

    public DefaultHttpHeaders(boolean validate2) {
        this.head.before = this.head.after = (this.head = new HeaderEntry(-1, null, null));
        this.validate = validate2;
    }

    void validateHeaderValue0(String headerValue) {
        if (KNOWN_VALUES.contains(headerValue)) {
            return;
        }
        DefaultHttpHeaders.validateHeaderValue(headerValue);
    }

    @Override
    public HttpHeaders add(String name2, Object value2) {
        String strVal = DefaultHttpHeaders.toString(value2);
        boolean validateName = false;
        if (this.validate) {
            this.validateHeaderValue0(strVal);
            validateName = !KNOWN_NAMES.contains(name2);
        }
        int h2 = DefaultHttpHeaders.hash(name2, validateName);
        int i = DefaultHttpHeaders.index(h2);
        this.add0(h2, i, name2, strVal);
        return this;
    }

    @Override
    public HttpHeaders add(String name2, Iterable<?> values2) {
        boolean validateName = false;
        if (this.validate) {
            validateName = !KNOWN_NAMES.contains(name2);
        }
        int h2 = DefaultHttpHeaders.hash(name2, validateName);
        int i = DefaultHttpHeaders.index(h2);
        for (Object v : values2) {
            String vstr = DefaultHttpHeaders.toString(v);
            if (this.validate) {
                this.validateHeaderValue0(vstr);
            }
            this.add0(h2, i, name2, vstr);
        }
        return this;
    }

    private void add0(int h2, int i, String name2, String value2) {
        HeaderEntry newEntry;
        HeaderEntry e = this.entries[i];
        this.entries[i] = newEntry = new HeaderEntry(h2, name2, value2);
        newEntry.next = e;
        newEntry.addBefore(this.head);
    }

    @Override
    public HttpHeaders remove(String name2) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        int h2 = DefaultHttpHeaders.hash(name2, false);
        int i = DefaultHttpHeaders.index(h2);
        this.remove0(h2, i, name2);
        return this;
    }

    private void remove0(int h2, int i, String name2) {
        HeaderEntry next2;
        HeaderEntry e = this.entries[i];
        if (e == null) {
            return;
        }
        while (e.hash == h2 && DefaultHttpHeaders.eq(name2, e.key)) {
            e.remove();
            next2 = e.next;
            if (next2 != null) {
                this.entries[i] = next2;
                e = next2;
                continue;
            }
            this.entries[i] = null;
            return;
        }
        while ((next2 = e.next) != null) {
            if (next2.hash == h2 && DefaultHttpHeaders.eq(name2, next2.key)) {
                e.next = next2.next;
                next2.remove();
                continue;
            }
            e = next2;
        }
    }

    @Override
    public HttpHeaders set(String name2, Object value2) {
        String strVal = DefaultHttpHeaders.toString(value2);
        boolean validateName = false;
        if (this.validate) {
            this.validateHeaderValue0(strVal);
            validateName = !KNOWN_NAMES.contains(name2);
        }
        int h2 = DefaultHttpHeaders.hash(name2, validateName);
        int i = DefaultHttpHeaders.index(h2);
        this.remove0(h2, i, name2);
        this.add0(h2, i, name2, strVal);
        return this;
    }

    @Override
    public HttpHeaders set(String name2, Iterable<?> values2) {
        if (values2 == null) {
            throw new NullPointerException("values");
        }
        boolean validateName = false;
        if (this.validate) {
            validateName = !KNOWN_NAMES.contains(name2);
        }
        int h2 = DefaultHttpHeaders.hash(name2, validateName);
        int i = DefaultHttpHeaders.index(h2);
        this.remove0(h2, i, name2);
        for (Object v : values2) {
            if (v == null) break;
            String strVal = DefaultHttpHeaders.toString(v);
            if (this.validate) {
                this.validateHeaderValue0(strVal);
            }
            this.add0(h2, i, name2, strVal);
        }
        return this;
    }

    @Override
    public HttpHeaders clear() {
        Arrays.fill(this.entries, null);
        this.head.before = this.head.after = this.head;
        return this;
    }

    @Override
    public String get(String name2) {
        return this.get(name2, false);
    }

    private String get(String name2, boolean last2) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        int h2 = DefaultHttpHeaders.hash(name2, false);
        int i = DefaultHttpHeaders.index(h2);
        HeaderEntry e = this.entries[i];
        String value2 = null;
        while (e != null) {
            if (e.hash == h2 && DefaultHttpHeaders.eq(name2, e.key)) {
                value2 = e.value;
                if (last2) break;
            }
            e = e.next;
        }
        return value2;
    }

    @Override
    public List<String> getAll(String name2) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        LinkedList<String> values2 = new LinkedList<String>();
        int h2 = DefaultHttpHeaders.hash(name2, false);
        int i = DefaultHttpHeaders.index(h2);
        HeaderEntry e = this.entries[i];
        while (e != null) {
            if (e.hash == h2 && DefaultHttpHeaders.eq(name2, e.key)) {
                values2.addFirst(e.value);
            }
            e = e.next;
        }
        return values2;
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        LinkedList<Map.Entry<String, String>> all = new LinkedList<Map.Entry<String, String>>();
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            all.add(e);
            e = e.after;
        }
        return all;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new HeaderIterator();
    }

    @Override
    public boolean contains(String name2) {
        return this.get(name2, true) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public boolean contains(String name2, String value2, boolean ignoreCaseValue) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        int h2 = DefaultHttpHeaders.hash(name2, false);
        int i = DefaultHttpHeaders.index(h2);
        HeaderEntry e = this.entries[i];
        while (e != null) {
            if (e.hash == h2 && DefaultHttpHeaders.eq(name2, e.key) && (ignoreCaseValue ? e.value.equalsIgnoreCase(value2) : e.value.equals(value2))) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public Set<String> names() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.key);
            e = e.after;
        }
        return names;
    }

    private static String toString(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof String) {
            return (String)value2;
        }
        if (value2 instanceof Number) {
            return value2.toString();
        }
        if (value2 instanceof Date) {
            return HttpHeaderDateFormat.get().format((Date)value2);
        }
        if (value2 instanceof Calendar) {
            return HttpHeaderDateFormat.get().format(((Calendar)value2).getTime());
        }
        return value2.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HeaderEntry
    implements Map.Entry<String, String> {
        final int hash;
        final String key;
        String value;
        HeaderEntry next;
        HeaderEntry before;
        HeaderEntry after;

        HeaderEntry(int hash2, String key, String value2) {
            this.hash = hash2;
            this.key = key;
            this.value = value2;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void addBefore(HeaderEntry e) {
            this.after = e;
            this.before = e.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value2) {
            if (value2 == null) {
                throw new NullPointerException("value");
            }
            if (DefaultHttpHeaders.this.validate) {
                DefaultHttpHeaders.this.validateHeaderValue0(value2);
            }
            String oldValue = this.value;
            this.value = value2;
            return oldValue;
        }

        public String toString() {
            return this.key + '=' + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HeaderIterator
    implements Iterator<Map.Entry<String, String>> {
        private HeaderEntry current;

        private HeaderIterator() {
            this.current = DefaultHttpHeaders.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current.after != DefaultHttpHeaders.this.head;
        }

        @Override
        public Map.Entry<String, String> next() {
            this.current = this.current.after;
            if (this.current == DefaultHttpHeaders.this.head) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

