/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpHeaders;
import org.jboss.netty.handler.codec.http.HttpCodecUtil;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.util.internal.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpMessage
implements HttpMessage {
    private final HttpHeaders headers = new DefaultHttpHeaders(true);
    private HttpVersion version;
    private ChannelBuffer content = ChannelBuffers.EMPTY_BUFFER;
    private boolean chunked;

    protected DefaultHttpMessage(HttpVersion version2) {
        this.setProtocolVersion(version2);
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    @Deprecated
    public void addHeader(String name2, Object value2) {
        this.headers.add(name2, value2);
    }

    @Override
    @Deprecated
    public void setHeader(String name2, Object value2) {
        this.headers.set(name2, value2);
    }

    @Override
    @Deprecated
    public void setHeader(String name2, Iterable<?> values2) {
        this.headers.set(name2, values2);
    }

    @Override
    @Deprecated
    public void removeHeader(String name2) {
        this.headers.remove(name2);
    }

    @Override
    public boolean isChunked() {
        if (this.chunked) {
            return true;
        }
        return HttpCodecUtil.isTransferEncodingChunked(this);
    }

    @Override
    public void setChunked(boolean chunked2) {
        this.chunked = chunked2;
        if (chunked2) {
            this.setContent(ChannelBuffers.EMPTY_BUFFER);
        }
    }

    @Override
    @Deprecated
    public void clearHeaders() {
        this.headers.clear();
    }

    @Override
    public void setContent(ChannelBuffer content) {
        if (content == null) {
            content = ChannelBuffers.EMPTY_BUFFER;
        }
        if (content.readable() && this.isChunked()) {
            throw new IllegalArgumentException("non-empty content disallowed if this.chunked == true");
        }
        this.content = content;
    }

    @Override
    @Deprecated
    public String getHeader(String name2) {
        return this.headers.get(name2);
    }

    @Override
    @Deprecated
    public List<String> getHeaders(String name2) {
        return this.headers.getAll(name2);
    }

    @Override
    @Deprecated
    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers.entries();
    }

    @Override
    @Deprecated
    public boolean containsHeader(String name2) {
        return this.headers.contains(name2);
    }

    @Override
    @Deprecated
    public Set<String> getHeaderNames() {
        return this.headers.names();
    }

    @Override
    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public void setProtocolVersion(HttpVersion version2) {
        if (version2 == null) {
            throw new NullPointerException("version");
        }
        this.version = version2;
    }

    @Override
    public ChannelBuffer getContent() {
        return this.content;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(version: ");
        buf.append(this.getProtocolVersion().getText());
        buf.append(", keepAlive: ");
        buf.append(HttpHeaders.isKeepAlive(this));
        buf.append(", chunked: ");
        buf.append(this.isChunked());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    void appendHeaders(StringBuilder buf) {
        for (Map.Entry e : this.headers()) {
            buf.append((String)e.getKey());
            buf.append(": ");
            buf.append((String)e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }
}

