/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpMessageDecoder
extends ReplayingDecoder<State> {
    private final int maxInitialLineLength;
    private final int maxHeaderSize;
    private final int maxChunkSize;
    private HttpMessage message;
    private ChannelBuffer content;
    private long chunkSize;
    private int headerSize;
    private int contentRead;

    protected HttpMessageDecoder() {
        this(4096, 8192, 8192);
    }

    protected HttpMessageDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
        super(State.SKIP_CONTROL_CHARS, true);
        if (maxInitialLineLength <= 0) {
            throw new IllegalArgumentException("maxInitialLineLength must be a positive integer: " + maxInitialLineLength);
        }
        if (maxHeaderSize <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be a positive integer: " + maxHeaderSize);
        }
        if (maxChunkSize < 0) {
            throw new IllegalArgumentException("maxChunkSize must be a positive integer: " + maxChunkSize);
        }
        this.maxInitialLineLength = maxInitialLineLength;
        this.maxHeaderSize = maxHeaderSize;
        this.maxChunkSize = maxChunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer2, State state) throws Exception {
        switch (state) {
            case SKIP_CONTROL_CHARS: {
                try {
                    HttpMessageDecoder.skipControlCharacters(buffer2);
                    this.checkpoint(State.READ_INITIAL);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.checkpoint();
                    throw throwable;
                }
                this.checkpoint();
                {
                }
            }
            case READ_INITIAL: {
                String[] initialLine = HttpMessageDecoder.splitInitialLine(HttpMessageDecoder.readLine(buffer2, this.maxInitialLineLength));
                if (initialLine.length < 3) {
                    this.checkpoint(State.SKIP_CONTROL_CHARS);
                    return null;
                }
                this.message = this.createMessage(initialLine);
                this.checkpoint(State.READ_HEADER);
            }
            case READ_HEADER: {
                State nextState = this.readHeaders(buffer2);
                this.checkpoint(nextState);
                if (nextState == State.READ_CHUNK_SIZE) {
                    this.message.setChunked(true);
                    return this.message;
                }
                if (nextState == State.SKIP_CONTROL_CHARS) {
                    this.message.headers().remove("Transfer-Encoding");
                    this.resetState();
                    return this.message;
                }
                long contentLength = HttpHeaders.getContentLength(this.message, -1L);
                if (contentLength == 0L || contentLength == -1L && this.isDecodingRequest()) {
                    this.content = ChannelBuffers.EMPTY_BUFFER;
                    return this.reset();
                }
                switch (nextState) {
                    case READ_FIXED_LENGTH_CONTENT: {
                        if (contentLength <= (long)this.maxChunkSize && !HttpHeaders.is100ContinueExpected(this.message)) break;
                        this.checkpoint(State.READ_FIXED_LENGTH_CONTENT_AS_CHUNKS);
                        this.message.setChunked(true);
                        this.chunkSize = HttpHeaders.getContentLength(this.message, -1L);
                        return this.message;
                    }
                    case READ_VARIABLE_LENGTH_CONTENT: {
                        if (buffer2.readableBytes() <= this.maxChunkSize && !HttpHeaders.is100ContinueExpected(this.message)) break;
                        this.checkpoint(State.READ_VARIABLE_LENGTH_CONTENT_AS_CHUNKS);
                        this.message.setChunked(true);
                        return this.message;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected state: " + (Object)((Object)nextState));
                    }
                }
                return null;
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int toRead = this.actualReadableBytes();
                if (toRead > this.maxChunkSize) {
                    toRead = this.maxChunkSize;
                }
                if (!this.message.isChunked()) {
                    this.message.setChunked(true);
                    return new Object[]{this.message, new DefaultHttpChunk(buffer2.readBytes(toRead))};
                }
                return new DefaultHttpChunk(buffer2.readBytes(toRead));
            }
            case READ_VARIABLE_LENGTH_CONTENT_AS_CHUNKS: {
                int toRead = this.actualReadableBytes();
                if (toRead > this.maxChunkSize) {
                    toRead = this.maxChunkSize;
                }
                DefaultHttpChunk chunk = new DefaultHttpChunk(buffer2.readBytes(toRead));
                if (!buffer2.readable()) {
                    this.reset();
                    if (!chunk.isLast()) {
                        return new Object[]{chunk, HttpChunk.LAST_CHUNK};
                    }
                }
                return chunk;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                return this.readFixedLengthContent(buffer2);
            }
            case READ_FIXED_LENGTH_CONTENT_AS_CHUNKS: {
                long chunkSize = this.chunkSize;
                int readLimit = this.actualReadableBytes();
                if (readLimit == 0) {
                    return null;
                }
                int toRead = readLimit;
                if (toRead > this.maxChunkSize) {
                    toRead = this.maxChunkSize;
                }
                if ((long)toRead > chunkSize) {
                    toRead = (int)chunkSize;
                }
                DefaultHttpChunk chunk = new DefaultHttpChunk(buffer2.readBytes(toRead));
                chunkSize = chunkSize > (long)toRead ? (chunkSize -= (long)toRead) : 0L;
                this.chunkSize = chunkSize;
                if (chunkSize == 0L) {
                    this.reset();
                    if (!chunk.isLast()) {
                        return new Object[]{chunk, HttpChunk.LAST_CHUNK};
                    }
                }
                return chunk;
            }
            case READ_CHUNK_SIZE: {
                String line2 = HttpMessageDecoder.readLine(buffer2, this.maxInitialLineLength);
                int chunkSize = HttpMessageDecoder.getChunkSize(line2);
                this.chunkSize = chunkSize;
                if (chunkSize == 0) {
                    this.checkpoint(State.READ_CHUNK_FOOTER);
                    return null;
                }
                if (chunkSize > this.maxChunkSize) {
                    this.checkpoint(State.READ_CHUNKED_CONTENT_AS_CHUNKS);
                } else {
                    this.checkpoint(State.READ_CHUNKED_CONTENT);
                }
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                DefaultHttpChunk chunk = new DefaultHttpChunk(buffer2.readBytes((int)this.chunkSize));
                this.checkpoint(State.READ_CHUNK_DELIMITER);
                return chunk;
            }
            case READ_CHUNKED_CONTENT_AS_CHUNKS: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                int chunkSize = (int)this.chunkSize;
                int readLimit = this.actualReadableBytes();
                if (readLimit == 0) {
                    return null;
                }
                int toRead = chunkSize;
                if (toRead > this.maxChunkSize) {
                    toRead = this.maxChunkSize;
                }
                if (toRead > readLimit) {
                    toRead = readLimit;
                }
                DefaultHttpChunk chunk = new DefaultHttpChunk(buffer2.readBytes(toRead));
                chunkSize = chunkSize > toRead ? (chunkSize -= toRead) : 0;
                this.chunkSize = chunkSize;
                if (chunkSize == 0) {
                    this.checkpoint(State.READ_CHUNK_DELIMITER);
                }
                if (!chunk.isLast()) {
                    return chunk;
                }
            }
            case READ_CHUNK_DELIMITER: {
                while (true) {
                    byte next2;
                    if ((next2 = buffer2.readByte()) == 13) {
                        if (buffer2.readByte() != 10) continue;
                        this.checkpoint(State.READ_CHUNK_SIZE);
                        return null;
                    }
                    if (next2 == 10) break;
                }
                this.checkpoint(State.READ_CHUNK_SIZE);
                return null;
            }
            case READ_CHUNK_FOOTER: {
                HttpChunkTrailer trailer = this.readTrailingHeaders(buffer2);
                if (this.maxChunkSize == 0) {
                    return this.reset();
                }
                this.reset();
                return trailer;
            }
            case UPGRADED: {
                int readableBytes = this.actualReadableBytes();
                if (readableBytes > 0) {
                    return buffer2.readBytes(this.actualReadableBytes());
                }
                return null;
            }
        }
        throw new Error("Shouldn't reach here.");
    }

    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse res = (HttpResponse)msg;
            int code2 = res.getStatus().getCode();
            if (code2 >= 100 && code2 < 200) {
                return code2 != 101 || res.headers().contains("Sec-WebSocket-Accept");
            }
            switch (code2) {
                case 204: 
                case 205: 
                case 304: {
                    return true;
                }
            }
        }
        return false;
    }

    private Object reset() {
        HttpMessage message = this.message;
        ChannelBuffer content = this.content;
        if (content != null) {
            message.setContent(content);
            this.content = null;
        }
        this.resetState();
        this.message = null;
        return message;
    }

    private void resetState() {
        HttpResponse res;
        if (!this.isDecodingRequest() && (res = (HttpResponse)this.message) != null && res.getStatus().getCode() == 101) {
            this.checkpoint(State.UPGRADED);
            return;
        }
        this.checkpoint(State.SKIP_CONTROL_CHARS);
    }

    private static void skipControlCharacters(ChannelBuffer buffer2) {
        char c;
        while (Character.isISOControl(c = (char)buffer2.readUnsignedByte()) || Character.isWhitespace(c)) {
        }
        buffer2.readerIndex(buffer2.readerIndex() - 1);
    }

    private Object readFixedLengthContent(ChannelBuffer buffer2) {
        long length = HttpHeaders.getContentLength(this.message, -1L);
        assert (length <= Integer.MAX_VALUE);
        int toRead = (int)length - this.contentRead;
        if (toRead > this.actualReadableBytes()) {
            toRead = this.actualReadableBytes();
        }
        this.contentRead += toRead;
        if (length < (long)this.contentRead) {
            if (!this.message.isChunked()) {
                this.message.setChunked(true);
                return new Object[]{this.message, new DefaultHttpChunk(buffer2.readBytes(toRead))};
            }
            return new DefaultHttpChunk(buffer2.readBytes(toRead));
        }
        if (this.content == null) {
            this.content = buffer2.readBytes((int)length);
        } else {
            this.content.writeBytes(buffer2, (int)length);
        }
        return this.reset();
    }

    private State readHeaders(ChannelBuffer buffer2) throws TooLongFrameException {
        this.headerSize = 0;
        HttpMessage message = this.message;
        String line2 = this.readHeader(buffer2);
        String name2 = null;
        String value2 = null;
        if (line2.length() != 0) {
            message.headers().clear();
            do {
                char firstChar = line2.charAt(0);
                if (name2 != null && (firstChar == ' ' || firstChar == '\t')) {
                    value2 = value2 + ' ' + line2.trim();
                    continue;
                }
                if (name2 != null) {
                    message.headers().add(name2, value2);
                }
                String[] header2 = HttpMessageDecoder.splitHeader(line2);
                name2 = header2[0];
                value2 = header2[1];
            } while ((line2 = this.readHeader(buffer2)).length() != 0);
            if (name2 != null) {
                message.headers().add(name2, value2);
            }
        }
        State nextState = this.isContentAlwaysEmpty(message) ? State.SKIP_CONTROL_CHARS : (message.isChunked() ? State.READ_CHUNK_SIZE : (HttpHeaders.getContentLength(message, -1L) >= 0L ? State.READ_FIXED_LENGTH_CONTENT : State.READ_VARIABLE_LENGTH_CONTENT));
        return nextState;
    }

    private HttpChunkTrailer readTrailingHeaders(ChannelBuffer buffer2) throws TooLongFrameException {
        this.headerSize = 0;
        String line2 = this.readHeader(buffer2);
        String lastHeader = null;
        if (line2.length() != 0) {
            DefaultHttpChunkTrailer trailer = new DefaultHttpChunkTrailer();
            do {
                char firstChar = line2.charAt(0);
                if (lastHeader != null && (firstChar == ' ' || firstChar == '\t')) {
                    List<String> current2 = trailer.trailingHeaders().getAll(lastHeader);
                    if (current2.isEmpty()) continue;
                    int lastPos = current2.size() - 1;
                    String newString = current2.get(lastPos) + line2.trim();
                    current2.set(lastPos, newString);
                    continue;
                }
                String[] header2 = HttpMessageDecoder.splitHeader(line2);
                String name2 = header2[0];
                if (!(name2.equalsIgnoreCase("Content-Length") || name2.equalsIgnoreCase("Transfer-Encoding") || name2.equalsIgnoreCase("Trailer"))) {
                    trailer.trailingHeaders().add(name2, header2[1]);
                }
                lastHeader = name2;
            } while ((line2 = this.readHeader(buffer2)).length() != 0);
            return trailer;
        }
        return HttpChunk.LAST_CHUNK;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String readHeader(ChannelBuffer buffer2) throws TooLongFrameException {
        StringBuilder sb = new StringBuilder(64);
        int headerSize = this.headerSize;
        block4: while (true) {
            char nextByte = (char)buffer2.readByte();
            ++headerSize;
            switch (nextByte) {
                case '\r': {
                    nextByte = (char)buffer2.readByte();
                    ++headerSize;
                    if (nextByte != '\n') break;
                    break block4;
                }
                case '\n': {
                    break block4;
                }
            }
            if (headerSize >= this.maxHeaderSize) {
                throw new TooLongFrameException("HTTP header is larger than " + this.maxHeaderSize + " bytes.");
            }
            sb.append(nextByte);
        }
        this.headerSize = headerSize;
        return sb.toString();
    }

    protected abstract boolean isDecodingRequest();

    protected abstract HttpMessage createMessage(String[] var1) throws Exception;

    private static int getChunkSize(String hex) {
        hex = hex.trim();
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c != ';' && !Character.isWhitespace(c) && !Character.isISOControl(c)) continue;
            hex = hex.substring(0, i);
            break;
        }
        return Integer.parseInt(hex, 16);
    }

    private static String readLine(ChannelBuffer buffer2, int maxLineLength) throws TooLongFrameException {
        StringBuilder sb = new StringBuilder(64);
        int lineLength = 0;
        while (true) {
            byte nextByte;
            if ((nextByte = buffer2.readByte()) == 13) {
                nextByte = buffer2.readByte();
                if (nextByte != 10) continue;
                return sb.toString();
            }
            if (nextByte == 10) {
                return sb.toString();
            }
            if (lineLength >= maxLineLength) {
                throw new TooLongFrameException("An HTTP line is larger than " + maxLineLength + " bytes.");
            }
            ++lineLength;
            sb.append((char)nextByte);
        }
    }

    private static String[] splitInitialLine(String sb) {
        int aStart = HttpMessageDecoder.findNonWhitespace(sb, 0);
        int aEnd = HttpMessageDecoder.findWhitespace(sb, aStart);
        int bStart = HttpMessageDecoder.findNonWhitespace(sb, aEnd);
        int bEnd = HttpMessageDecoder.findWhitespace(sb, bStart);
        int cStart = HttpMessageDecoder.findNonWhitespace(sb, bEnd);
        int cEnd = HttpMessageDecoder.findEndOfString(sb);
        return new String[]{sb.substring(aStart, aEnd), sb.substring(bStart, bEnd), cStart < cEnd ? sb.substring(cStart, cEnd) : ""};
    }

    private static String[] splitHeader(String sb) {
        int valueStart;
        int colonEnd;
        int nameStart;
        char ch;
        int nameEnd;
        int length = sb.length();
        for (nameEnd = nameStart = HttpMessageDecoder.findNonWhitespace(sb, 0); nameEnd < length && (ch = sb.charAt(nameEnd)) != ':' && !Character.isWhitespace(ch); ++nameEnd) {
        }
        for (colonEnd = nameEnd; colonEnd < length; ++colonEnd) {
            if (sb.charAt(colonEnd) != ':') continue;
            ++colonEnd;
            break;
        }
        if ((valueStart = HttpMessageDecoder.findNonWhitespace(sb, colonEnd)) == length) {
            return new String[]{sb.substring(nameStart, nameEnd), ""};
        }
        int valueEnd = HttpMessageDecoder.findEndOfString(sb);
        return new String[]{sb.substring(nameStart, nameEnd), sb.substring(valueStart, valueEnd)};
    }

    private static int findNonWhitespace(String sb, int offset) {
        int result2;
        for (result2 = offset; result2 < sb.length() && Character.isWhitespace(sb.charAt(result2)); ++result2) {
        }
        return result2;
    }

    private static int findWhitespace(String sb, int offset) {
        int result2;
        for (result2 = offset; result2 < sb.length() && !Character.isWhitespace(sb.charAt(result2)); ++result2) {
        }
        return result2;
    }

    private static int findEndOfString(String sb) {
        int result2;
        for (result2 = sb.length(); result2 > 0 && Character.isWhitespace(sb.charAt(result2 - 1)); --result2) {
        }
        return result2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        SKIP_CONTROL_CHARS,
        READ_INITIAL,
        READ_HEADER,
        READ_VARIABLE_LENGTH_CONTENT,
        READ_VARIABLE_LENGTH_CONTENT_AS_CHUNKS,
        READ_FIXED_LENGTH_CONTENT,
        READ_FIXED_LENGTH_CONTENT_AS_CHUNKS,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNKED_CONTENT_AS_CHUNKS,
        READ_CHUNK_DELIMITER,
        READ_CHUNK_FOOTER,
        UPGRADED;

    }
}

