/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.handler.codec.http.HttpConstants;

public class QueryStringEncoder {
    private final Charset charset;
    private final String uri;
    private final List<Param> params = new ArrayList<Param>();

    public QueryStringEncoder(String uri) {
        this(uri, HttpConstants.DEFAULT_CHARSET);
    }

    public QueryStringEncoder(String uri, Charset charset2) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (charset2 == null) {
            throw new NullPointerException("charset");
        }
        this.uri = uri;
        this.charset = charset2;
    }

    @Deprecated
    public QueryStringEncoder(String uri, String charset2) {
        this(uri, Charset.forName(charset2));
    }

    public void addParam(String name2, String value2) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        if (value2 == null) {
            throw new NullPointerException("value");
        }
        this.params.add(new Param(name2, value2));
    }

    public URI toUri() throws URISyntaxException {
        return new URI(this.toString());
    }

    public String toString() {
        if (this.params.isEmpty()) {
            return this.uri;
        }
        StringBuilder sb = new StringBuilder(this.uri).append('?');
        for (int i = 0; i < this.params.size(); ++i) {
            Param param2 = this.params.get(i);
            sb.append(QueryStringEncoder.encodeComponent(param2.name, this.charset));
            sb.append('=');
            sb.append(QueryStringEncoder.encodeComponent(param2.value, this.charset));
            if (i == this.params.size() - 1) continue;
            sb.append('&');
        }
        return sb.toString();
    }

    private static String encodeComponent(String s2, Charset charset2) {
        try {
            return URLEncoder.encode(s2, charset2.name()).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(charset2.name());
        }
    }

    private static final class Param {
        final String name;
        final String value;

        Param(String name2, String value2) {
            this.value = value2;
            this.name = name2;
        }
    }
}

