/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.cookie;

import java.util.Iterator;
import org.jboss.netty.handler.codec.http.cookie.Cookie;
import org.jboss.netty.handler.codec.http.cookie.CookieEncoder;
import org.jboss.netty.handler.codec.http.cookie.CookieUtil;
import org.jboss.netty.handler.codec.http.cookie.DefaultCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientCookieEncoder
extends CookieEncoder {
    public static final ClientCookieEncoder STRICT = new ClientCookieEncoder(true);
    public static final ClientCookieEncoder LAX = new ClientCookieEncoder(false);

    private ClientCookieEncoder(boolean strict) {
        super(strict);
    }

    public String encode(String name2, String value2) {
        return this.encode((Cookie)new DefaultCookie(name2, value2));
    }

    public String encode(Cookie cookie2) {
        if (cookie2 == null) {
            throw new NullPointerException("cookie");
        }
        StringBuilder buf = new StringBuilder();
        this.encode(buf, cookie2);
        return CookieUtil.stripTrailingSeparator(buf);
    }

    public String encode(Cookie ... cookies2) {
        if (cookies2 == null) {
            throw new NullPointerException("cookies");
        }
        if (cookies2.length == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (Cookie c : cookies2) {
            if (c == null) break;
            this.encode(buf, c);
        }
        return CookieUtil.stripTrailingSeparatorOrNull(buf);
    }

    public String encode(Iterable<? extends Cookie> cookies2) {
        Cookie c;
        if (cookies2 == null) {
            throw new NullPointerException("cookies");
        }
        Iterator<? extends Cookie> cookiesIt = cookies2.iterator();
        if (!cookiesIt.hasNext()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        while (cookiesIt.hasNext() && (c = cookiesIt.next()) != null) {
            this.encode(buf, c);
        }
        return CookieUtil.stripTrailingSeparatorOrNull(buf);
    }

    private void encode(StringBuilder buf, Cookie c) {
        String name2 = c.name();
        String value2 = c.value() != null ? c.value() : "";
        this.validateCookie(name2, value2);
        if (c.wrap()) {
            CookieUtil.addQuoted(buf, name2, value2);
        } else {
            CookieUtil.add(buf, name2, value2);
        }
    }
}

