/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.cookie;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jboss.netty.handler.codec.http.HttpHeaderDateFormat;
import org.jboss.netty.handler.codec.http.cookie.Cookie;
import org.jboss.netty.handler.codec.http.cookie.CookieEncoder;
import org.jboss.netty.handler.codec.http.cookie.CookieUtil;
import org.jboss.netty.handler.codec.http.cookie.DefaultCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerCookieEncoder
extends CookieEncoder {
    public static final ServerCookieEncoder STRICT = new ServerCookieEncoder(true);
    public static final ServerCookieEncoder LAX = new ServerCookieEncoder(false);

    private ServerCookieEncoder(boolean strict) {
        super(strict);
    }

    public String encode(String name2, String value2) {
        return this.encode((Cookie)new DefaultCookie(name2, value2));
    }

    public String encode(Cookie cookie2) {
        if (cookie2 == null) {
            throw new NullPointerException("cookie");
        }
        String name2 = cookie2.name();
        String value2 = cookie2.value() != null ? cookie2.value() : "";
        this.validateCookie(name2, value2);
        StringBuilder buf = new StringBuilder();
        if (cookie2.wrap()) {
            CookieUtil.addQuoted(buf, name2, value2);
        } else {
            CookieUtil.add(buf, name2, value2);
        }
        if (cookie2.maxAge() != Integer.MIN_VALUE) {
            CookieUtil.add(buf, "Max-Age", cookie2.maxAge());
            Date expires = new Date((long)(cookie2.maxAge() * 1000) + System.currentTimeMillis());
            CookieUtil.add(buf, "Expires", HttpHeaderDateFormat.get().format(expires));
        }
        if (cookie2.path() != null) {
            CookieUtil.add(buf, "Path", cookie2.path());
        }
        if (cookie2.domain() != null) {
            CookieUtil.add(buf, "Domain", cookie2.domain());
        }
        if (cookie2.isSecure()) {
            CookieUtil.add(buf, "Secure");
        }
        if (cookie2.isHttpOnly()) {
            CookieUtil.add(buf, "HTTPOnly");
        }
        return CookieUtil.stripTrailingSeparator(buf);
    }

    public List<String> encode(Cookie ... cookies2) {
        if (cookies2 == null) {
            throw new NullPointerException("cookies");
        }
        if (cookies2.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> encoded = new ArrayList<String>(cookies2.length);
        for (Cookie c : cookies2) {
            if (c == null) break;
            encoded.add(this.encode(c));
        }
        return encoded;
    }

    public List<String> encode(Collection<? extends Cookie> cookies2) {
        if (cookies2 == null) {
            throw new NullPointerException("cookies");
        }
        if (cookies2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> encoded = new ArrayList<String>(cookies2.size());
        for (Cookie cookie2 : cookies2) {
            if (cookie2 == null) break;
            encoded.add(this.encode(cookie2));
        }
        return encoded;
    }

    public List<String> encode(Iterable<? extends Cookie> cookies2) {
        if (cookies2 == null) {
            throw new NullPointerException("cookies");
        }
        if (cookies2.iterator().hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<String> encoded = new ArrayList<String>();
        for (Cookie cookie2 : cookies2) {
            if (cookie2 == null) break;
            encoded.add(this.encode(cookie2));
        }
        return encoded;
    }
}

