/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.multipart;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpConstants;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.multipart.Attribute;
import org.jboss.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import org.jboss.netty.handler.codec.http.multipart.FileUpload;
import org.jboss.netty.handler.codec.http.multipart.HttpData;
import org.jboss.netty.handler.codec.http.multipart.HttpDataFactory;
import org.jboss.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import org.jboss.netty.handler.codec.http.multipart.InterfaceHttpData;
import org.jboss.netty.handler.codec.http.multipart.InternalAttribute;
import org.jboss.netty.handler.stream.ChunkedInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPostRequestEncoder
implements ChunkedInput {
    private static final Map<Pattern, String> percentEncodings = new HashMap<Pattern, String>();
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final Charset charset;
    private boolean isChunked;
    private final List<InterfaceHttpData> bodyListDatas;
    final List<InterfaceHttpData> multipartHttpDatas;
    private final boolean isMultipart;
    String multipartDataBoundary;
    String multipartMixedBoundary;
    private boolean headerFinalized;
    private final EncoderMode encoderMode;
    private boolean isLastChunk;
    private boolean isLastChunkSent;
    private FileUpload currentFileUpload;
    private boolean duringMixedMode;
    private long globalBodySize;
    private ListIterator<InterfaceHttpData> iterator;
    private ChannelBuffer currentBuffer;
    private InterfaceHttpData currentData;
    private boolean isKey = true;

    public HttpPostRequestEncoder(HttpRequest request, boolean multipart) throws ErrorDataEncoderException {
        this(new DefaultHttpDataFactory(16384L), request, multipart, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestEncoder(HttpDataFactory factory, HttpRequest request, boolean multipart) throws ErrorDataEncoderException {
        this(factory, request, multipart, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestEncoder(HttpDataFactory factory, HttpRequest request, boolean multipart, Charset charset2) throws ErrorDataEncoderException {
        this(factory, request, multipart, charset2, EncoderMode.RFC1738);
    }

    public HttpPostRequestEncoder(HttpDataFactory factory, HttpRequest request, boolean multipart, Charset charset2, EncoderMode encoderMode) throws ErrorDataEncoderException {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (charset2 == null) {
            throw new NullPointerException("charset");
        }
        HttpMethod method = request.getMethod();
        if (!(method.equals(HttpMethod.POST) || method.equals(HttpMethod.PUT) || method.equals(HttpMethod.PATCH))) {
            throw new ErrorDataEncoderException("Cannot create a Encoder if not a POST");
        }
        this.request = request;
        this.charset = charset2;
        this.factory = factory;
        this.encoderMode = encoderMode;
        this.bodyListDatas = new ArrayList<InterfaceHttpData>();
        this.isLastChunk = false;
        this.isLastChunkSent = false;
        this.isMultipart = multipart;
        this.multipartHttpDatas = new ArrayList<InterfaceHttpData>();
        if (this.isMultipart) {
            this.initDataMultipart();
        }
    }

    public void cleanFiles() {
        this.factory.cleanRequestHttpDatas(this.request);
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    private void initDataMultipart() {
        this.multipartDataBoundary = HttpPostRequestEncoder.getNewMultipartDelimiter();
    }

    private void initMixedMultipart() {
        this.multipartMixedBoundary = HttpPostRequestEncoder.getNewMultipartDelimiter();
    }

    private static String getNewMultipartDelimiter() {
        Random random = new Random();
        return Long.toHexString(random.nextLong()).toLowerCase();
    }

    public List<InterfaceHttpData> getBodyListAttributes() {
        return this.bodyListDatas;
    }

    public void setBodyHttpDatas(List<InterfaceHttpData> datas) throws ErrorDataEncoderException {
        if (datas == null) {
            throw new NullPointerException("datas");
        }
        this.globalBodySize = 0L;
        this.bodyListDatas.clear();
        this.currentFileUpload = null;
        this.duringMixedMode = false;
        this.multipartHttpDatas.clear();
        for (InterfaceHttpData data : datas) {
            this.addBodyHttpData(data);
        }
    }

    public void addBodyAttribute(String name2, String value2) throws ErrorDataEncoderException {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        String svalue = value2;
        if (value2 == null) {
            svalue = "";
        }
        Attribute data = this.factory.createAttribute(this.request, name2, svalue);
        this.addBodyHttpData(data);
    }

    public void addBodyFileUpload(String name2, File file2, String contentType2, boolean isText) throws ErrorDataEncoderException {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        if (file2 == null) {
            throw new NullPointerException("file");
        }
        String scontentType = contentType2;
        String contentTransferEncoding = null;
        if (contentType2 == null) {
            scontentType = isText ? "text/plain" : "application/octet-stream";
        }
        if (!isText) {
            contentTransferEncoding = HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value();
        }
        FileUpload fileUpload = this.factory.createFileUpload(this.request, name2, file2.getName(), scontentType, contentTransferEncoding, null, file2.length());
        try {
            fileUpload.setContent(file2);
        }
        catch (IOException e) {
            throw new ErrorDataEncoderException(e);
        }
        this.addBodyHttpData(fileUpload);
    }

    public void addBodyFileUploads(String name2, File[] file2, String[] contentType2, boolean[] isText) throws ErrorDataEncoderException {
        if (file2.length != contentType2.length && file2.length != isText.length) {
            throw new NullPointerException("Different array length");
        }
        for (int i = 0; i < file2.length; ++i) {
            this.addBodyFileUpload(name2, file2[i], contentType2[i], isText[i]);
        }
    }

    public void addBodyHttpData(InterfaceHttpData data) throws ErrorDataEncoderException {
        if (this.headerFinalized) {
            throw new ErrorDataEncoderException("Cannot add value once finalized");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.bodyListDatas.add(data);
        if (!this.isMultipart) {
            if (data instanceof Attribute) {
                Attribute attribute = (Attribute)data;
                try {
                    String key = this.encodeAttribute(attribute.getName(), this.charset);
                    String value2 = this.encodeAttribute(attribute.getValue(), this.charset);
                    Attribute newattribute = this.factory.createAttribute(this.request, key, value2);
                    this.multipartHttpDatas.add(newattribute);
                    this.globalBodySize += (long)(newattribute.getName().length() + 1) + newattribute.length() + 1L;
                }
                catch (IOException e) {
                    throw new ErrorDataEncoderException(e);
                }
            } else if (data instanceof FileUpload) {
                FileUpload fileUpload = (FileUpload)data;
                String key = this.encodeAttribute(fileUpload.getName(), this.charset);
                String value3 = this.encodeAttribute(fileUpload.getFilename(), this.charset);
                Attribute newattribute = this.factory.createAttribute(this.request, key, value3);
                this.multipartHttpDatas.add(newattribute);
                this.globalBodySize += (long)(newattribute.getName().length() + 1) + newattribute.length() + 1L;
            }
            return;
        }
        if (data instanceof Attribute) {
            InternalAttribute internal2;
            if (this.duringMixedMode) {
                internal2 = new InternalAttribute(this.charset);
                internal2.addValue("\r\n--" + this.multipartMixedBoundary + "--");
                this.multipartHttpDatas.add(internal2);
                this.multipartMixedBoundary = null;
                this.currentFileUpload = null;
                this.duringMixedMode = false;
            }
            internal2 = new InternalAttribute(this.charset);
            if (!this.multipartHttpDatas.isEmpty()) {
                internal2.addValue("\r\n");
            }
            internal2.addValue("--" + this.multipartDataBoundary + "\r\n");
            Attribute attribute = (Attribute)data;
            internal2.addValue("Content-Disposition: form-data; name=\"" + attribute.getName() + "\"\r\n");
            Charset localcharset = attribute.getCharset();
            if (localcharset != null) {
                internal2.addValue("Content-Type: text/plain; charset=" + localcharset + "\r\n");
            }
            internal2.addValue("\r\n");
            this.multipartHttpDatas.add(internal2);
            this.multipartHttpDatas.add(data);
            this.globalBodySize += attribute.length() + (long)internal2.size();
        } else if (data instanceof FileUpload) {
            boolean localMixed;
            FileUpload fileUpload = (FileUpload)data;
            InternalAttribute internal3 = new InternalAttribute(this.charset);
            if (!this.multipartHttpDatas.isEmpty()) {
                internal3.addValue("\r\n");
            }
            if (this.duringMixedMode) {
                if (this.currentFileUpload != null && this.currentFileUpload.getName().equals(fileUpload.getName())) {
                    localMixed = true;
                } else {
                    internal3.addValue("--" + this.multipartMixedBoundary + "--");
                    this.multipartHttpDatas.add(internal3);
                    this.multipartMixedBoundary = null;
                    internal3 = new InternalAttribute(this.charset);
                    internal3.addValue("\r\n");
                    localMixed = false;
                    this.currentFileUpload = fileUpload;
                    this.duringMixedMode = false;
                }
            } else if (this.encoderMode != EncoderMode.HTML5 && this.currentFileUpload != null && this.currentFileUpload.getName().equals(fileUpload.getName())) {
                this.initMixedMultipart();
                InternalAttribute pastAttribute = (InternalAttribute)this.multipartHttpDatas.get(this.multipartHttpDatas.size() - 2);
                this.globalBodySize -= (long)pastAttribute.size();
                StringBuilder replacement = new StringBuilder(139 + this.multipartDataBoundary.length() + this.multipartMixedBoundary.length() * 2 + fileUpload.getFilename().length() + fileUpload.getName().length());
                replacement.append("--");
                replacement.append(this.multipartDataBoundary);
                replacement.append("\r\n");
                replacement.append("Content-Disposition");
                replacement.append(": ");
                replacement.append("form-data");
                replacement.append("; ");
                replacement.append("name");
                replacement.append("=\"");
                replacement.append(fileUpload.getName());
                replacement.append("\"\r\n");
                replacement.append("Content-Type");
                replacement.append(": ");
                replacement.append("multipart/mixed");
                replacement.append("; ");
                replacement.append("boundary");
                replacement.append('=');
                replacement.append(this.multipartMixedBoundary);
                replacement.append("\r\n\r\n");
                replacement.append("--");
                replacement.append(this.multipartMixedBoundary);
                replacement.append("\r\n");
                replacement.append("Content-Disposition");
                replacement.append(": ");
                replacement.append("attachment");
                replacement.append("; ");
                replacement.append("filename");
                replacement.append("=\"");
                replacement.append(fileUpload.getFilename());
                replacement.append("\"\r\n");
                pastAttribute.setValue(replacement.toString(), 1);
                pastAttribute.setValue("", 2);
                this.globalBodySize += (long)pastAttribute.size();
                localMixed = true;
                this.duringMixedMode = true;
            } else {
                localMixed = false;
                this.currentFileUpload = fileUpload;
                this.duringMixedMode = false;
            }
            if (localMixed) {
                internal3.addValue("--" + this.multipartMixedBoundary + "\r\n");
                internal3.addValue("Content-Disposition: attachment; filename=\"" + fileUpload.getFilename() + "\"\r\n");
            } else {
                internal3.addValue("--" + this.multipartDataBoundary + "\r\n");
                internal3.addValue("Content-Disposition: form-data; name=\"" + fileUpload.getName() + "\"; " + "filename" + "=\"" + fileUpload.getFilename() + "\"\r\n");
            }
            internal3.addValue("Content-Type: " + fileUpload.getContentType());
            String contentTransferEncoding = fileUpload.getContentTransferEncoding();
            if (contentTransferEncoding != null && contentTransferEncoding.equals(HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value())) {
                internal3.addValue("\r\nContent-Transfer-Encoding: " + HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value() + "\r\n\r\n");
            } else if (fileUpload.getCharset() != null) {
                internal3.addValue("; charset=" + fileUpload.getCharset() + "\r\n\r\n");
            } else {
                internal3.addValue("\r\n\r\n");
            }
            this.multipartHttpDatas.add(internal3);
            this.multipartHttpDatas.add(data);
            this.globalBodySize += fileUpload.length() + (long)internal3.size();
        }
    }

    public HttpRequest finalizeRequest() throws ErrorDataEncoderException {
        HttpHeaders headers2 = this.request.headers();
        if (!this.headerFinalized) {
            if (this.isMultipart) {
                InternalAttribute internal2 = new InternalAttribute(this.charset);
                if (this.duringMixedMode) {
                    internal2.addValue("\r\n--" + this.multipartMixedBoundary + "--");
                }
                internal2.addValue("\r\n--" + this.multipartDataBoundary + "--\r\n");
                this.multipartHttpDatas.add(internal2);
                this.multipartMixedBoundary = null;
                this.currentFileUpload = null;
                this.duringMixedMode = false;
                this.globalBodySize += (long)internal2.size();
            }
        } else {
            throw new ErrorDataEncoderException("Header already encoded");
        }
        this.headerFinalized = true;
        List<String> contentTypes = headers2.getAll("Content-Type");
        List<String> transferEncoding = headers2.getAll("Transfer-Encoding");
        if (contentTypes != null) {
            headers2.remove("Content-Type");
            for (String contentType2 : contentTypes) {
                String lowercased = contentType2.toLowerCase();
                if (lowercased.startsWith("multipart/form-data") || lowercased.startsWith("application/x-www-form-urlencoded")) continue;
                headers2.add("Content-Type", contentType2);
            }
        }
        if (this.isMultipart) {
            String value2 = "multipart/form-data; boundary=" + this.multipartDataBoundary;
            headers2.add("Content-Type", value2);
        } else {
            headers2.add("Content-Type", "application/x-www-form-urlencoded");
        }
        long realSize = this.globalBodySize;
        if (this.isMultipart) {
            this.iterator = this.multipartHttpDatas.listIterator();
        } else {
            --realSize;
            this.iterator = this.multipartHttpDatas.listIterator();
        }
        headers2.set("Content-Length", String.valueOf(realSize));
        if (realSize > 8096L || this.isMultipart) {
            this.isChunked = true;
            if (transferEncoding != null) {
                headers2.remove("Transfer-Encoding");
                for (String v : transferEncoding) {
                    if (v.equalsIgnoreCase("chunked")) continue;
                    headers2.add("Transfer-Encoding", v);
                }
            }
            headers2.add("Transfer-Encoding", "chunked");
            this.request.setContent(ChannelBuffers.EMPTY_BUFFER);
        } else {
            HttpChunk chunk = this.nextChunk();
            this.request.setContent(chunk.getContent());
        }
        return this.request;
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    private String encodeAttribute(String s2, Charset charset2) throws ErrorDataEncoderException {
        if (s2 == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(s2, charset2.name());
            if (this.encoderMode == EncoderMode.RFC3986) {
                for (Map.Entry<Pattern, String> entry : percentEncodings.entrySet()) {
                    String replacement = entry.getValue();
                    encoded = entry.getKey().matcher(encoded).replaceAll(replacement);
                }
            }
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new ErrorDataEncoderException(charset2.name(), e);
        }
    }

    private ChannelBuffer fillChannelBuffer() {
        int length = this.currentBuffer.readableBytes();
        if (length > 8096) {
            ChannelBuffer slice2 = this.currentBuffer.slice(this.currentBuffer.readerIndex(), 8096);
            this.currentBuffer.skipBytes(8096);
            return slice2;
        }
        ChannelBuffer slice3 = this.currentBuffer;
        this.currentBuffer = null;
        return slice3;
    }

    private HttpChunk encodeNextChunkMultipart(int sizeleft) throws ErrorDataEncoderException {
        ChannelBuffer buffer2;
        if (this.currentData == null) {
            return null;
        }
        if (this.currentData instanceof InternalAttribute) {
            buffer2 = ((InternalAttribute)this.currentData).toChannelBuffer();
            this.currentData = null;
        } else {
            if (this.currentData instanceof Attribute) {
                try {
                    buffer2 = ((Attribute)this.currentData).getChunk(sizeleft);
                }
                catch (IOException e) {
                    throw new ErrorDataEncoderException(e);
                }
            }
            try {
                buffer2 = ((HttpData)this.currentData).getChunk(sizeleft);
            }
            catch (IOException e) {
                throw new ErrorDataEncoderException(e);
            }
            if (buffer2.capacity() == 0) {
                this.currentData = null;
                return null;
            }
        }
        this.currentBuffer = this.currentBuffer == null ? buffer2 : ChannelBuffers.wrappedBuffer(this.currentBuffer, buffer2);
        if (this.currentBuffer.readableBytes() < 8096) {
            this.currentData = null;
            return null;
        }
        buffer2 = this.fillChannelBuffer();
        return new DefaultHttpChunk(buffer2);
    }

    private HttpChunk encodeNextChunkUrlEncoded(int sizeleft) throws ErrorDataEncoderException {
        ChannelBuffer buffer2;
        if (this.currentData == null) {
            return null;
        }
        int size2 = sizeleft;
        if (this.isKey) {
            String key = this.currentData.getName();
            buffer2 = ChannelBuffers.wrappedBuffer(key.getBytes());
            this.isKey = false;
            if (this.currentBuffer == null) {
                this.currentBuffer = ChannelBuffers.wrappedBuffer(buffer2, ChannelBuffers.wrappedBuffer("=".getBytes()));
                size2 -= buffer2.readableBytes() + 1;
            } else {
                this.currentBuffer = ChannelBuffers.wrappedBuffer(this.currentBuffer, buffer2, ChannelBuffers.wrappedBuffer("=".getBytes()));
                size2 -= buffer2.readableBytes() + 1;
            }
            if (this.currentBuffer.readableBytes() >= 8096) {
                buffer2 = this.fillChannelBuffer();
                return new DefaultHttpChunk(buffer2);
            }
        }
        try {
            buffer2 = ((HttpData)this.currentData).getChunk(size2);
        }
        catch (IOException e) {
            throw new ErrorDataEncoderException(e);
        }
        ChannelBuffer delimiter = null;
        if (buffer2.readableBytes() < size2) {
            this.isKey = true;
            ChannelBuffer channelBuffer = delimiter = this.iterator.hasNext() ? ChannelBuffers.wrappedBuffer("&".getBytes()) : null;
        }
        if (buffer2.capacity() == 0) {
            this.currentData = null;
            if (this.currentBuffer == null) {
                this.currentBuffer = delimiter;
            } else if (delimiter != null) {
                this.currentBuffer = ChannelBuffers.wrappedBuffer(this.currentBuffer, delimiter);
            }
            if (this.currentBuffer.readableBytes() >= 8096) {
                buffer2 = this.fillChannelBuffer();
                return new DefaultHttpChunk(buffer2);
            }
            return null;
        }
        this.currentBuffer = this.currentBuffer == null ? (delimiter != null ? ChannelBuffers.wrappedBuffer(buffer2, delimiter) : buffer2) : (delimiter != null ? ChannelBuffers.wrappedBuffer(this.currentBuffer, buffer2, delimiter) : ChannelBuffers.wrappedBuffer(this.currentBuffer, buffer2));
        if (this.currentBuffer.readableBytes() < 8096) {
            this.currentData = null;
            this.isKey = true;
            return null;
        }
        buffer2 = this.fillChannelBuffer();
        return new DefaultHttpChunk(buffer2);
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public HttpChunk nextChunk() throws ErrorDataEncoderException {
        HttpChunk chunk;
        if (this.isLastChunk) {
            this.isLastChunkSent = true;
            return new DefaultHttpChunk(ChannelBuffers.EMPTY_BUFFER);
        }
        int size2 = 8096;
        if (this.currentBuffer != null) {
            size2 -= this.currentBuffer.readableBytes();
        }
        if (size2 <= 0) {
            ChannelBuffer buffer2 = this.fillChannelBuffer();
            return new DefaultHttpChunk(buffer2);
        }
        if (this.currentData != null) {
            if (this.isMultipart ? (chunk = this.encodeNextChunkMultipart(size2)) != null : (chunk = this.encodeNextChunkUrlEncoded(size2)) != null) {
                return chunk;
            }
            size2 = 8096 - this.currentBuffer.readableBytes();
        }
        if (!this.iterator.hasNext()) {
            this.isLastChunk = true;
            ChannelBuffer buffer3 = this.currentBuffer;
            this.currentBuffer = null;
            return new DefaultHttpChunk(buffer3);
        }
        while (size2 > 0 && this.iterator.hasNext()) {
            this.currentData = this.iterator.next();
            chunk = this.isMultipart ? this.encodeNextChunkMultipart(size2) : this.encodeNextChunkUrlEncoded(size2);
            if (chunk == null) {
                size2 = 8096 - this.currentBuffer.readableBytes();
                continue;
            }
            return chunk;
        }
        this.isLastChunk = true;
        if (this.currentBuffer == null) {
            this.isLastChunkSent = true;
            return new DefaultHttpChunk(ChannelBuffers.EMPTY_BUFFER);
        }
        ChannelBuffer buffer4 = this.currentBuffer;
        this.currentBuffer = null;
        return new DefaultHttpChunk(buffer4);
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.isLastChunkSent;
    }

    @Override
    public boolean hasNextChunk() throws Exception {
        return !this.isLastChunkSent;
    }

    static {
        percentEncodings.put(Pattern.compile("\\*"), "%2A");
        percentEncodings.put(Pattern.compile("\\+"), "%20");
        percentEncodings.put(Pattern.compile("%7E"), "~");
    }

    public static class ErrorDataEncoderException
    extends Exception {
        private static final long serialVersionUID = 5020247425493164465L;

        public ErrorDataEncoderException() {
        }

        public ErrorDataEncoderException(String msg) {
            super(msg);
        }

        public ErrorDataEncoderException(Throwable cause) {
            super(cause);
        }

        public ErrorDataEncoderException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EncoderMode {
        RFC1738,
        RFC3986,
        HTML5;

    }
}

