/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.multipart.DiskFileUpload;
import org.jboss.netty.handler.codec.http.multipart.FileUpload;
import org.jboss.netty.handler.codec.http.multipart.InterfaceHttpData;
import org.jboss.netty.handler.codec.http.multipart.MemoryFileUpload;

public class MixedFileUpload
implements FileUpload {
    private FileUpload fileUpload;
    private final long limitSize;
    private final long definedSize;
    protected long maxSize = -1L;

    public MixedFileUpload(String name2, String filename, String contentType2, String contentTransferEncoding, Charset charset2, long size2, long limitSize) {
        this.limitSize = limitSize;
        this.fileUpload = size2 > this.limitSize ? new DiskFileUpload(name2, filename, contentType2, contentTransferEncoding, charset2, size2) : new MemoryFileUpload(name2, filename, contentType2, contentTransferEncoding, charset2, size2);
        this.definedSize = size2;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        this.fileUpload.setMaxSize(maxSize);
    }

    public void checkSize(long newSize) throws IOException {
        if (this.maxSize >= 0L && newSize > this.maxSize) {
            throw new IOException("Size exceed allowed maximum capacity");
        }
    }

    public void addContent(ChannelBuffer buffer2, boolean last2) throws IOException {
        if (this.fileUpload instanceof MemoryFileUpload) {
            this.checkSize(this.fileUpload.length() + (long)buffer2.readableBytes());
            if (this.fileUpload.length() + (long)buffer2.readableBytes() > this.limitSize) {
                DiskFileUpload diskFileUpload = new DiskFileUpload(this.fileUpload.getName(), this.fileUpload.getFilename(), this.fileUpload.getContentType(), this.fileUpload.getContentTransferEncoding(), this.fileUpload.getCharset(), this.definedSize);
                diskFileUpload.setMaxSize(this.maxSize);
                if (((MemoryFileUpload)this.fileUpload).getChannelBuffer() != null) {
                    diskFileUpload.addContent(((MemoryFileUpload)this.fileUpload).getChannelBuffer(), false);
                }
                this.fileUpload = diskFileUpload;
            }
        }
        this.fileUpload.addContent(buffer2, last2);
    }

    public void delete() {
        this.fileUpload.delete();
    }

    public byte[] get() throws IOException {
        return this.fileUpload.get();
    }

    public ChannelBuffer getChannelBuffer() throws IOException {
        return this.fileUpload.getChannelBuffer();
    }

    public Charset getCharset() {
        return this.fileUpload.getCharset();
    }

    public String getContentType() {
        return this.fileUpload.getContentType();
    }

    public String getContentTransferEncoding() {
        return this.fileUpload.getContentTransferEncoding();
    }

    public String getFilename() {
        return this.fileUpload.getFilename();
    }

    public String getString() throws IOException {
        return this.fileUpload.getString();
    }

    public String getString(Charset encoding) throws IOException {
        return this.fileUpload.getString(encoding);
    }

    public boolean isCompleted() {
        return this.fileUpload.isCompleted();
    }

    public boolean isInMemory() {
        return this.fileUpload.isInMemory();
    }

    public long length() {
        return this.fileUpload.length();
    }

    public boolean renameTo(File dest) throws IOException {
        return this.fileUpload.renameTo(dest);
    }

    public void setCharset(Charset charset2) {
        this.fileUpload.setCharset(charset2);
    }

    public void setContent(ChannelBuffer buffer2) throws IOException {
        this.checkSize(buffer2.readableBytes());
        if ((long)buffer2.readableBytes() > this.limitSize && this.fileUpload instanceof MemoryFileUpload) {
            this.fileUpload = new DiskFileUpload(this.fileUpload.getName(), this.fileUpload.getFilename(), this.fileUpload.getContentType(), this.fileUpload.getContentTransferEncoding(), this.fileUpload.getCharset(), this.definedSize);
            this.fileUpload.setMaxSize(this.maxSize);
        }
        this.fileUpload.setContent(buffer2);
    }

    public void setContent(File file2) throws IOException {
        this.checkSize(file2.length());
        if (file2.length() > this.limitSize && this.fileUpload instanceof MemoryFileUpload) {
            this.fileUpload = new DiskFileUpload(this.fileUpload.getName(), this.fileUpload.getFilename(), this.fileUpload.getContentType(), this.fileUpload.getContentTransferEncoding(), this.fileUpload.getCharset(), this.definedSize);
            this.fileUpload.setMaxSize(this.maxSize);
        }
        this.fileUpload.setContent(file2);
    }

    public void setContent(InputStream inputStream) throws IOException {
        if (this.fileUpload instanceof MemoryFileUpload) {
            this.fileUpload = new DiskFileUpload(this.fileUpload.getName(), this.fileUpload.getFilename(), this.fileUpload.getContentType(), this.fileUpload.getContentTransferEncoding(), this.fileUpload.getCharset(), this.definedSize);
            this.fileUpload.setMaxSize(this.maxSize);
        }
        this.fileUpload.setContent(inputStream);
    }

    public void setContentType(String contentType2) {
        this.fileUpload.setContentType(contentType2);
    }

    public void setContentTransferEncoding(String contentTransferEncoding) {
        this.fileUpload.setContentTransferEncoding(contentTransferEncoding);
    }

    public void setFilename(String filename) {
        this.fileUpload.setFilename(filename);
    }

    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return this.fileUpload.getHttpDataType();
    }

    public String getName() {
        return this.fileUpload.getName();
    }

    public int compareTo(InterfaceHttpData o) {
        return this.fileUpload.compareTo(o);
    }

    public String toString() {
        return "Mixed: " + this.fileUpload.toString();
    }

    public ChannelBuffer getChunk(int length) throws IOException {
        return this.fileUpload.getChunk(length);
    }

    public File getFile() throws IOException {
        return this.fileUpload.getFile();
    }
}

