/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.websocketx;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocket00FrameDecoder
extends ReplayingDecoder<VoidEnum> {
    private static final long DEFAULT_MAX_FRAME_SIZE = 16384L;
    private final long maxFrameSize;
    private boolean receivedClosingHandshake;

    public WebSocket00FrameDecoder() {
        this(16384L);
    }

    @Deprecated
    public WebSocket00FrameDecoder(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public WebSocket00FrameDecoder(long maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer2, VoidEnum state) throws Exception {
        if (this.receivedClosingHandshake) {
            buffer2.skipBytes(this.actualReadableBytes());
            return null;
        }
        byte type = buffer2.readByte();
        if ((type & 0x80) == 128) {
            return this.decodeBinaryFrame(type, buffer2);
        }
        return this.decodeTextFrame(buffer2);
    }

    private WebSocketFrame decodeBinaryFrame(byte type, ChannelBuffer buffer2) throws TooLongFrameException {
        byte b;
        long frameSize = 0L;
        int lengthFieldSize = 0;
        do {
            b = buffer2.readByte();
            frameSize <<= 7;
            if ((frameSize |= (long)(b & 0x7F)) > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            if (++lengthFieldSize <= 8) continue;
            throw new TooLongFrameException();
        } while ((b & 0x80) == 128);
        if (type == -1 && frameSize == 0L) {
            this.receivedClosingHandshake = true;
            return new CloseWebSocketFrame();
        }
        return new BinaryWebSocketFrame(buffer2.readBytes((int)frameSize));
    }

    private WebSocketFrame decodeTextFrame(ChannelBuffer buffer2) throws TooLongFrameException {
        int rbytes;
        int ridx = buffer2.readerIndex();
        int delimPos = buffer2.indexOf(ridx, ridx + (rbytes = this.actualReadableBytes()), (byte)-1);
        if (delimPos == -1) {
            if ((long)rbytes > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            return null;
        }
        int frameSize = delimPos - ridx;
        if ((long)frameSize > this.maxFrameSize) {
            throw new TooLongFrameException();
        }
        ChannelBuffer binaryData = buffer2.readBytes(frameSize);
        buffer2.skipBytes(1);
        int ffDelimPos = binaryData.indexOf(binaryData.readerIndex(), binaryData.writerIndex(), (byte)-1);
        if (ffDelimPos >= 0) {
            throw new IllegalArgumentException("a text frame should not contain 0xFF.");
        }
        return new TextWebSocketFrame(binaryData);
    }
}

