/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.marshalling;

import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.marshalling.ChannelBufferByteInput;
import org.jboss.netty.handler.codec.marshalling.LimitingByteInput;
import org.jboss.netty.handler.codec.marshalling.UnmarshallerProvider;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibleMarshallingDecoder
extends ReplayingDecoder<VoidEnum> {
    protected final UnmarshallerProvider provider;
    protected final int maxObjectSize;
    private boolean discardingTooLongFrame;

    public CompatibleMarshallingDecoder(UnmarshallerProvider provider, int maxObjectSize) {
        this.provider = provider;
        this.maxObjectSize = maxObjectSize;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer2, VoidEnum state) throws Exception {
        if (this.discardingTooLongFrame) {
            buffer2.skipBytes(this.actualReadableBytes());
            this.checkpoint();
            return null;
        }
        Unmarshaller unmarshaller = this.provider.getUnmarshaller(ctx);
        Object input2 = new ChannelBufferByteInput(buffer2);
        if (this.maxObjectSize != Integer.MAX_VALUE) {
            input2 = new LimitingByteInput((ByteInput)input2, this.maxObjectSize);
        }
        try {
            unmarshaller.start((ByteInput)input2);
            Object obj2 = unmarshaller.readObject();
            unmarshaller.finish();
            Object object = obj2;
            return object;
        }
        catch (LimitingByteInput.TooBigObjectException e) {
            this.discardingTooLongFrame = true;
            throw new TooLongFrameException();
        }
        finally {
            unmarshaller.close();
        }
    }

    @Override
    protected Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer2, VoidEnum state) throws Exception {
        switch (buffer2.readableBytes()) {
            case 0: {
                return null;
            }
            case 1: {
                if (buffer2.getByte(buffer2.readerIndex()) != 121) break;
                buffer2.skipBytes(1);
                return null;
            }
        }
        Object decoded = this.decode(ctx, channel, buffer2, state);
        return decoded;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (e.getCause() instanceof TooLongFrameException) {
            e.getChannel().close();
        } else {
            super.exceptionCaught(ctx, e);
        }
    }
}

