/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.marshalling;

import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.marshalling.ChannelBufferByteInput;
import org.jboss.netty.handler.codec.marshalling.UnmarshallerProvider;

public class MarshallingDecoder
extends LengthFieldBasedFrameDecoder {
    private final UnmarshallerProvider provider;

    public MarshallingDecoder(UnmarshallerProvider provider) {
        this(provider, 0x100000);
    }

    public MarshallingDecoder(UnmarshallerProvider provider, int maxObjectSize) {
        super(maxObjectSize, 0, 4, 0, 4);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer2) throws Exception {
        ChannelBuffer frame = (ChannelBuffer)super.decode(ctx, channel, buffer2);
        if (frame == null) {
            return null;
        }
        Unmarshaller unmarshaller = this.provider.getUnmarshaller(ctx);
        ChannelBufferByteInput input2 = new ChannelBufferByteInput(frame);
        try {
            unmarshaller.start((ByteInput)input2);
            Object obj2 = unmarshaller.readObject();
            unmarshaller.finish();
            Object object = obj2;
            return object;
        }
        finally {
            unmarshaller.close();
        }
    }

    protected ChannelBuffer extractFrame(ChannelBuffer buffer2, int index2, int length) {
        return buffer2.slice(index2, length);
    }
}

