/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.protobuf;

import com.google.protobuf.CodedInputStream;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.CorruptedFrameException;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class ProtobufVarint32FrameDecoder
extends FrameDecoder {
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer2) throws Exception {
        buffer2.markReaderIndex();
        byte[] buf = new byte[5];
        for (int i = 0; i < buf.length; ++i) {
            if (!buffer2.readable()) {
                buffer2.resetReaderIndex();
                return null;
            }
            buf[i] = buffer2.readByte();
            if (buf[i] < 0) continue;
            int length = CodedInputStream.newInstance((byte[])buf, (int)0, (int)(i + 1)).readRawVarint32();
            if (length < 0) {
                throw new CorruptedFrameException("negative length: " + length);
            }
            if (buffer2.readableBytes() < length) {
                buffer2.resetReaderIndex();
                return null;
            }
            return buffer2.readBytes(length);
        }
        throw new CorruptedFrameException("length wider than 32-bit");
    }
}

