/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.rtsp;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.embedder.DecoderEmbedder;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMessageDecoder;

public abstract class RtspMessageDecoder
extends HttpMessageDecoder {
    private final DecoderEmbedder<HttpMessage> aggregator;

    protected RtspMessageDecoder() {
        this(4096, 8192, 8192);
    }

    protected RtspMessageDecoder(int maxInitialLineLength, int maxHeaderSize, int maxContentLength) {
        super(maxInitialLineLength, maxHeaderSize, maxContentLength * 2);
        this.aggregator = new DecoderEmbedder(new HttpChunkAggregator(maxContentLength));
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer2, HttpMessageDecoder.State state) throws Exception {
        Object o = super.decode(ctx, channel, buffer2, state);
        if (o != null && this.aggregator.offer(o)) {
            return this.aggregator.poll();
        }
        return null;
    }

    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        boolean empty2 = super.isContentAlwaysEmpty(msg);
        if (empty2) {
            return true;
        }
        if (!msg.headers().contains("Content-Length")) {
            return true;
        }
        return empty2;
    }
}

