/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyHeaders;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyStreamFrame;
import org.jboss.netty.handler.codec.spdy.SpdyHeaders;
import org.jboss.netty.handler.codec.spdy.SpdyHeadersFrame;
import org.jboss.netty.util.internal.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSpdyHeadersFrame
extends DefaultSpdyStreamFrame
implements SpdyHeadersFrame {
    private boolean invalid;
    private boolean truncated;
    private final SpdyHeaders headers = new DefaultSpdyHeaders();

    public DefaultSpdyHeadersFrame(int streamId) {
        super(streamId);
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public void setInvalid() {
        this.invalid = true;
    }

    @Override
    public boolean isTruncated() {
        return this.truncated;
    }

    @Override
    public void setTruncated() {
        this.truncated = true;
    }

    @Override
    public SpdyHeaders headers() {
        return this.headers;
    }

    @Override
    @Deprecated
    public void addHeader(String name2, Object value2) {
        this.headers.add(name2, value2);
    }

    @Override
    @Deprecated
    public void setHeader(String name2, Object value2) {
        this.headers.set(name2, value2);
    }

    @Override
    @Deprecated
    public void setHeader(String name2, Iterable<?> values2) {
        this.headers.set(name2, values2);
    }

    @Override
    @Deprecated
    public void removeHeader(String name2) {
        this.headers.remove(name2);
    }

    @Override
    @Deprecated
    public void clearHeaders() {
        this.headers.clear();
    }

    @Override
    @Deprecated
    public String getHeader(String name2) {
        return this.headers.get(name2);
    }

    @Override
    @Deprecated
    public List<String> getHeaders(String name2) {
        return this.headers.getAll(name2);
    }

    @Override
    @Deprecated
    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers.entries();
    }

    @Override
    @Deprecated
    public boolean containsHeader(String name2) {
        return this.headers.contains(name2);
    }

    @Override
    @Deprecated
    public Set<String> getHeaderNames() {
        return this.headers.names();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(last: ");
        buf.append(this.isLast());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Stream-ID = ");
        buf.append(this.getStreamId());
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Headers:");
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    protected void appendHeaders(StringBuilder buf) {
        for (Map.Entry<String, String> e : this.headers()) {
            buf.append("    ");
            buf.append(e.getKey());
            buf.append(": ");
            buf.append(e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }
}

