/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.spdy.SpdyHeadersFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpdyHeaders
implements Iterable<Map.Entry<String, String>> {
    public static final SpdyHeaders EMPTY_HEADERS = new SpdyHeaders(){

        @Override
        public List<String> getAll(String name2) {
            return Collections.emptyList();
        }

        @Override
        public List<Map.Entry<String, String>> entries() {
            return Collections.emptyList();
        }

        @Override
        public boolean contains(String name2) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Set<String> names() {
            return Collections.emptySet();
        }

        @Override
        public SpdyHeaders add(String name2, Object value2) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public SpdyHeaders add(String name2, Iterable<?> values2) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public SpdyHeaders set(String name2, Object value2) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public SpdyHeaders set(String name2, Iterable<?> values2) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public SpdyHeaders remove(String name2) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public SpdyHeaders clear() {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return this.entries().iterator();
        }

        @Override
        public String get(String name2) {
            return null;
        }
    };

    public static String getHeader(SpdyHeadersFrame frame, String name2) {
        return frame.headers().get(name2);
    }

    public static String getHeader(SpdyHeadersFrame frame, String name2, String defaultValue) {
        String value2 = frame.headers().get(name2);
        if (value2 == null) {
            return defaultValue;
        }
        return value2;
    }

    public static void setHeader(SpdyHeadersFrame frame, String name2, Object value2) {
        frame.headers().set(name2, value2);
    }

    public static void setHeader(SpdyHeadersFrame frame, String name2, Iterable<?> values2) {
        frame.headers().set(name2, values2);
    }

    public static void addHeader(SpdyHeadersFrame frame, String name2, Object value2) {
        frame.headers().add(name2, value2);
    }

    public static void removeHost(SpdyHeadersFrame frame) {
        frame.headers().remove(":host");
    }

    public static String getHost(SpdyHeadersFrame frame) {
        return frame.headers().get(":host");
    }

    public static void setHost(SpdyHeadersFrame frame, String host2) {
        frame.headers().set(":host", host2);
    }

    public static void removeMethod(int spdyVersion, SpdyHeadersFrame frame) {
        frame.headers().remove(":method");
    }

    public static HttpMethod getMethod(int spdyVersion, SpdyHeadersFrame frame) {
        try {
            return HttpMethod.valueOf(frame.headers().get(":method"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setMethod(int spdyVersion, SpdyHeadersFrame frame, HttpMethod method) {
        frame.headers().set(":method", method.getName());
    }

    public static void removeScheme(int spdyVersion, SpdyHeadersFrame frame) {
        frame.headers().remove(":scheme");
    }

    public static String getScheme(int spdyVersion, SpdyHeadersFrame frame) {
        return frame.headers().get(":scheme");
    }

    public static void setScheme(int spdyVersion, SpdyHeadersFrame frame, String scheme2) {
        frame.headers().set(":scheme", scheme2);
    }

    public static void removeStatus(int spdyVersion, SpdyHeadersFrame frame) {
        frame.headers().remove(":status");
    }

    public static HttpResponseStatus getStatus(int spdyVersion, SpdyHeadersFrame frame) {
        try {
            String status = frame.headers().get(":status");
            int space = status.indexOf(32);
            if (space == -1) {
                return HttpResponseStatus.valueOf(Integer.parseInt(status));
            }
            int code2 = Integer.parseInt(status.substring(0, space));
            String reasonPhrase = status.substring(space + 1);
            HttpResponseStatus responseStatus = HttpResponseStatus.valueOf(code2);
            if (responseStatus.getReasonPhrase().equals(reasonPhrase)) {
                return responseStatus;
            }
            return new HttpResponseStatus(code2, reasonPhrase);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setStatus(int spdyVersion, SpdyHeadersFrame frame, HttpResponseStatus status) {
        frame.headers().set(":status", status.toString());
    }

    public static void removeUrl(int spdyVersion, SpdyHeadersFrame frame) {
        frame.headers().remove(":path");
    }

    public static String getUrl(int spdyVersion, SpdyHeadersFrame frame) {
        return frame.headers().get(":path");
    }

    public static void setUrl(int spdyVersion, SpdyHeadersFrame frame, String path2) {
        frame.headers().set(":path", path2);
    }

    public static void removeVersion(int spdyVersion, SpdyHeadersFrame frame) {
        frame.headers().remove(":version");
    }

    public static HttpVersion getVersion(int spdyVersion, SpdyHeadersFrame frame) {
        try {
            return HttpVersion.valueOf(frame.headers().get(":version"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setVersion(int spdyVersion, SpdyHeadersFrame frame, HttpVersion httpVersion) {
        frame.headers().set(":version", httpVersion.getText());
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.entries().iterator();
    }

    public abstract String get(String var1);

    public abstract List<String> getAll(String var1);

    public abstract List<Map.Entry<String, String>> entries();

    public abstract boolean contains(String var1);

    public abstract Set<String> names();

    public abstract SpdyHeaders add(String var1, Object var2);

    public abstract SpdyHeaders add(String var1, Iterable<?> var2);

    public abstract SpdyHeaders set(String var1, Object var2);

    public abstract SpdyHeaders set(String var1, Iterable<?> var2);

    public abstract SpdyHeaders remove(String var1);

    public abstract SpdyHeaders clear();

    public abstract boolean isEmpty();

    public static final class HttpNames {
        public static final String HOST = ":host";
        public static final String METHOD = ":method";
        public static final String PATH = ":path";
        public static final String SCHEME = ":scheme";
        public static final String STATUS = ":status";
        public static final String VERSION = ":version";

        private HttpNames() {
        }
    }
}

