/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.timeout;

import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelDownstreamHandler;
import org.jboss.netty.handler.timeout.WriteTimeoutException;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

@ChannelHandler.Sharable
public class WriteTimeoutHandler
extends SimpleChannelDownstreamHandler
implements ExternalResourceReleasable {
    static final WriteTimeoutException EXCEPTION = new WriteTimeoutException();
    private final Timer timer;
    private final long timeoutMillis;

    public WriteTimeoutHandler(Timer timer, int timeoutSeconds) {
        this(timer, timeoutSeconds, TimeUnit.SECONDS);
    }

    public WriteTimeoutHandler(Timer timer, long timeout2, TimeUnit unit) {
        if (timer == null) {
            throw new NullPointerException("timer");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.timer = timer;
        this.timeoutMillis = timeout2 <= 0L ? 0L : Math.max(unit.toMillis(timeout2), 1L);
    }

    public void releaseExternalResources() {
        this.timer.stop();
    }

    protected long getTimeoutMillis(MessageEvent e) {
        return this.timeoutMillis;
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        long timeoutMillis = this.getTimeoutMillis(e);
        if (timeoutMillis > 0L) {
            ChannelFuture future2 = e.getFuture();
            Timeout timeout2 = this.timer.newTimeout(new WriteTimeoutTask(ctx, future2), timeoutMillis, TimeUnit.MILLISECONDS);
            future2.addListener(new TimeoutCanceller(timeout2));
        }
        super.writeRequested(ctx, e);
    }

    protected void writeTimedOut(ChannelHandlerContext ctx) throws Exception {
        Channels.fireExceptionCaught(ctx, (Throwable)EXCEPTION);
    }

    private static final class TimeoutCanceller
    implements ChannelFutureListener {
        private final Timeout timeout;

        TimeoutCanceller(Timeout timeout2) {
            this.timeout = timeout2;
        }

        public void operationComplete(ChannelFuture future2) throws Exception {
            this.timeout.cancel();
        }
    }

    private final class WriteTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;
        private final ChannelFuture future;

        WriteTimeoutTask(ChannelHandlerContext ctx, ChannelFuture future2) {
            this.ctx = ctx;
            this.future = future2;
        }

        public void run(Timeout timeout2) throws Exception {
            if (timeout2.isCancelled()) {
                return;
            }
            if (!this.ctx.getChannel().isOpen()) {
                return;
            }
            if (this.future.setFailure(EXCEPTION)) {
                this.fireWriteTimeOut(this.ctx);
            }
        }

        private void fireWriteTimeOut(final ChannelHandlerContext ctx) {
            ctx.getPipeline().execute(new Runnable(){

                public void run() {
                    try {
                        WriteTimeoutHandler.this.writeTimedOut(ctx);
                    }
                    catch (Throwable t) {
                        Channels.fireExceptionCaught(ctx, t);
                    }
                }
            });
        }
    }
}

