/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.traffic;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.traffic.AbstractTrafficShapingHandler;
import org.jboss.netty.handler.traffic.TrafficCounter;
import org.jboss.netty.util.ObjectSizeEstimator;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class ChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private List<ToSend> messagesQueue = new LinkedList<ToSend>();
    private volatile Timeout writeTimeout;

    public ChannelTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval) {
        super(timer, writeLimit, readLimit, checkInterval);
    }

    public ChannelTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        super(timer, writeLimit, readLimit, checkInterval, maxTime);
    }

    public ChannelTrafficShapingHandler(Timer timer, long writeLimit, long readLimit) {
        super(timer, writeLimit, readLimit);
    }

    public ChannelTrafficShapingHandler(Timer timer, long checkInterval) {
        super(timer, checkInterval);
    }

    public ChannelTrafficShapingHandler(Timer timer) {
        super(timer);
    }

    public ChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval) {
        super(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval);
    }

    public ChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        super(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval, maxTime);
    }

    public ChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit) {
        super(objectSizeEstimator, timer, writeLimit, readLimit);
    }

    public ChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long checkInterval) {
        super(objectSizeEstimator, timer, checkInterval);
    }

    public ChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer) {
        super(objectSizeEstimator, timer);
    }

    protected synchronized void submitWrite(final ChannelHandlerContext ctx, MessageEvent evt, long delay) throws Exception {
        if (delay == 0L && this.messagesQueue.isEmpty()) {
            this.internalSubmitWrite(ctx, evt);
            return;
        }
        if (this.timer == null) {
            Thread.sleep(delay);
            this.internalSubmitWrite(ctx, evt);
            return;
        }
        ToSend newToSend = new ToSend(delay, evt);
        this.messagesQueue.add(newToSend);
        this.writeTimeout = this.timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout2) throws Exception {
                ChannelTrafficShapingHandler.this.sendAllValid(ctx);
            }
        }, delay + 1L, TimeUnit.MILLISECONDS);
    }

    private synchronized void sendAllValid(ChannelHandlerContext ctx) throws Exception {
        while (!this.messagesQueue.isEmpty()) {
            ToSend newToSend = this.messagesQueue.remove(0);
            if (newToSend.date <= System.currentTimeMillis()) {
                this.internalSubmitWrite(ctx, newToSend.toSend);
                continue;
            }
            this.messagesQueue.add(0, newToSend);
            break;
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.trafficCounter != null) {
            this.trafficCounter.stop();
        }
        this.messagesQueue.clear();
        if (this.writeTimeout != null) {
            this.writeTimeout.cancel();
        }
        super.channelClosed(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.setAttachment(Boolean.TRUE);
        ctx.getChannel().setReadable(false);
        if (this.trafficCounter == null && this.timer != null) {
            this.trafficCounter = new TrafficCounter(this, this.timer, "ChannelTC" + ctx.getChannel().getId(), this.checkInterval);
        }
        if (this.trafficCounter != null) {
            this.trafficCounter.start();
        }
        ctx.setAttachment(null);
        ctx.getChannel().setReadable(true);
        super.channelConnected(ctx, e);
    }

    private static final class ToSend {
        final long date;
        final MessageEvent toSend;

        private ToSend(long delay, MessageEvent toSend) {
            this.date = System.currentTimeMillis() + delay;
            this.toSend = toSend;
        }
    }
}

