/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

public final class NetUtil {
    private static final int IPV6_WORD_COUNT = 8;
    private static final int IPV6_MAX_CHAR_COUNT = 39;
    private static final int IPV6_BYTE_COUNT = 16;
    private static final int IPV6_MAX_CHAR_BETWEEN_SEPARATOR = 4;
    private static final int IPV6_MIN_SEPARATORS = 2;
    private static final int IPV6_MAX_SEPARATORS = 8;
    private static final int IPV4_BYTE_COUNT = 4;
    private static final int IPV4_MAX_CHAR_BETWEEN_SEPARATOR = 3;
    private static final int IPV4_SEPARATORS = 3;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NetUtil.class);

    public static byte[] createByteArrayFromIpAddressString(String ipAddressString) {
        if (NetUtil.isValidIpV4Address(ipAddressString)) {
            StringTokenizer tokenizer = new StringTokenizer(ipAddressString, ".");
            byte[] byteAddress = new byte[4];
            for (int i = 0; i < 4; ++i) {
                String token2 = tokenizer.nextToken();
                int tempInt = Integer.parseInt(token2);
                byteAddress[i] = (byte)tempInt;
            }
            return byteAddress;
        }
        if (NetUtil.isValidIpV6Address(ipAddressString)) {
            int i;
            int percentPos;
            if (ipAddressString.charAt(0) == '[') {
                ipAddressString = ipAddressString.substring(1, ipAddressString.length() - 1);
            }
            if ((percentPos = ipAddressString.indexOf(37)) >= 0) {
                ipAddressString = ipAddressString.substring(0, percentPos);
            }
            StringTokenizer tokenizer = new StringTokenizer(ipAddressString, ":.", true);
            ArrayList<String> hexStrings = new ArrayList<String>();
            ArrayList<String> decStrings = new ArrayList<String>();
            String token3 = "";
            String prevToken = "";
            int doubleColonIndex = -1;
            while (tokenizer.hasMoreTokens()) {
                prevToken = token3;
                token3 = tokenizer.nextToken();
                if (":".equals(token3)) {
                    if (":".equals(prevToken)) {
                        doubleColonIndex = hexStrings.size();
                        continue;
                    }
                    if (prevToken.length() == 0) continue;
                    hexStrings.add(prevToken);
                    continue;
                }
                if (!".".equals(token3)) continue;
                decStrings.add(prevToken);
            }
            if (":".equals(prevToken)) {
                if (":".equals(token3)) {
                    doubleColonIndex = hexStrings.size();
                } else {
                    hexStrings.add(token3);
                }
            } else if (".".equals(prevToken)) {
                decStrings.add(token3);
            }
            int hexStringsLength = 8;
            if (!decStrings.isEmpty()) {
                hexStringsLength -= 2;
            }
            if (doubleColonIndex != -1) {
                int numberToInsert = hexStringsLength - hexStrings.size();
                for (i = 0; i < numberToInsert; ++i) {
                    hexStrings.add(doubleColonIndex, "0");
                }
            }
            byte[] ipByteArray = new byte[16];
            for (i = 0; i < hexStrings.size(); ++i) {
                NetUtil.convertToBytes((String)hexStrings.get(i), ipByteArray, i << 1);
            }
            for (i = 0; i < decStrings.size(); ++i) {
                ipByteArray[i + 12] = (byte)(Integer.parseInt((String)decStrings.get(i)) & 0xFF);
            }
            return ipByteArray;
        }
        return null;
    }

    private static void convertToBytes(String hexWord, byte[] ipByteArray, int byteIndex) {
        int charValue;
        int hexWordLength = hexWord.length();
        int hexWordIndex = 0;
        ipByteArray[byteIndex] = 0;
        ipByteArray[byteIndex + 1] = 0;
        if (hexWordLength > 3) {
            charValue = NetUtil.getIntValue(hexWord.charAt(hexWordIndex++));
            int n = byteIndex;
            ipByteArray[n] = (byte)(ipByteArray[n] | charValue << 4);
        }
        if (hexWordLength > 2) {
            charValue = NetUtil.getIntValue(hexWord.charAt(hexWordIndex++));
            int n = byteIndex;
            ipByteArray[n] = (byte)(ipByteArray[n] | charValue);
        }
        if (hexWordLength > 1) {
            charValue = NetUtil.getIntValue(hexWord.charAt(hexWordIndex++));
            int n = byteIndex + 1;
            ipByteArray[n] = (byte)(ipByteArray[n] | charValue << 4);
        }
        charValue = NetUtil.getIntValue(hexWord.charAt(hexWordIndex));
        int n = byteIndex + 1;
        ipByteArray[n] = (byte)(ipByteArray[n] | charValue & 0xF);
    }

    static int getIntValue(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        c = Character.toLowerCase(c);
        switch (c) {
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    public static boolean isValidIpV6Address(String ipAddress) {
        int percentIdx;
        int length = ipAddress.length();
        boolean doubleColon = false;
        int numberOfColons = 0;
        int numberOfPeriods = 0;
        StringBuilder word = new StringBuilder();
        char c = '\u0000';
        int startOffset = 0;
        int endOffset = ipAddress.length();
        if (endOffset < 2) {
            return false;
        }
        if (ipAddress.charAt(0) == '[') {
            if (ipAddress.charAt(endOffset - 1) != ']') {
                return false;
            }
            startOffset = 1;
            --endOffset;
        }
        if ((percentIdx = ipAddress.indexOf(37, startOffset)) >= 0) {
            endOffset = percentIdx;
        }
        block4: for (int i = startOffset; i < endOffset; ++i) {
            char prevChar = c;
            c = ipAddress.charAt(i);
            switch (c) {
                case '.': {
                    if (++numberOfPeriods > 3) {
                        return false;
                    }
                    if (!NetUtil.isValidIp4Word(word.toString())) {
                        return false;
                    }
                    if (numberOfColons != 6 && !doubleColon) {
                        return false;
                    }
                    if (numberOfColons == 7 && ipAddress.charAt(startOffset) != ':' && ipAddress.charAt(1 + startOffset) != ':') {
                        return false;
                    }
                    word.delete(0, word.length());
                    continue block4;
                }
                case ':': {
                    if (i == startOffset && (ipAddress.length() <= i || ipAddress.charAt(i + 1) != ':')) {
                        return false;
                    }
                    if (++numberOfColons > 7) {
                        return false;
                    }
                    if (numberOfPeriods > 0) {
                        return false;
                    }
                    if (prevChar == ':') {
                        if (doubleColon) {
                            return false;
                        }
                        doubleColon = true;
                    }
                    word.delete(0, word.length());
                    continue block4;
                }
                default: {
                    if (word != null && word.length() > 3) {
                        return false;
                    }
                    if (!NetUtil.isValidHexChar(c)) {
                        return false;
                    }
                    word.append(c);
                }
            }
        }
        if (numberOfPeriods > 0) {
            if (numberOfPeriods != 3 || !NetUtil.isValidIp4Word(word.toString()) || numberOfColons >= 7) {
                return false;
            }
        } else {
            if (numberOfColons != 7 && !doubleColon) {
                return false;
            }
            if (word.length() == 0 && ipAddress.charAt(length - 1 - startOffset) == ':' && ipAddress.charAt(length - 2 - startOffset) != ':') {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidIp4Word(String word) {
        if (word.length() < 1 || word.length() > 3) {
            return false;
        }
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return Integer.parseInt(word) <= 255;
    }

    private static boolean isValidHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean isValidNumericChar(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isValidIpV4Address(String value2) {
        int periods = 0;
        int length = value2.length();
        if (length > 15) {
            return false;
        }
        StringBuilder word = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = value2.charAt(i);
            if (c == '.') {
                if (++periods > 3) {
                    return false;
                }
                if (word.length() == 0) {
                    return false;
                }
                if (Integer.parseInt(word.toString()) > 255) {
                    return false;
                }
                word.delete(0, word.length());
                continue;
            }
            if (!Character.isDigit(c)) {
                return false;
            }
            if (word.length() > 2) {
                return false;
            }
            word.append(c);
        }
        if (word.length() == 0 || Integer.parseInt(word.toString()) > 255) {
            return false;
        }
        return periods == 3;
    }

    public static Inet6Address getByName(CharSequence ip) {
        return NetUtil.getByName(ip, true);
    }

    public static Inet6Address getByName(CharSequence ip, boolean ipv4Mapped) {
        boolean isCompressed;
        int tmp;
        int i;
        byte[] bytes2 = new byte[16];
        int ipLength = ip.length();
        int compressBegin = 0;
        int compressLength = 0;
        int currentIndex = 0;
        int value2 = 0;
        int begin = -1;
        int ipv6Seperators = 0;
        int ipv4Seperators = 0;
        boolean needsShift = false;
        block6: for (i = 0; i < ipLength; ++i) {
            char c = ip.charAt(i);
            switch (c) {
                case ':': {
                    if (i - begin > 4 || ipv4Seperators > 0 || ++ipv6Seperators > 8 || currentIndex + 1 >= bytes2.length) {
                        return null;
                    }
                    value2 <<= 4 - (i - begin) << 2;
                    if (compressLength > 0) {
                        compressLength -= 2;
                    }
                    bytes2[currentIndex++] = (byte)((value2 & 0xF) << 4 | value2 >> 4 & 0xF);
                    bytes2[currentIndex++] = (byte)((value2 >> 8 & 0xF) << 4 | value2 >> 12 & 0xF);
                    tmp = i + 1;
                    if (tmp < ipLength && ip.charAt(tmp) == ':') {
                        if (compressBegin != 0 || ++tmp < ipLength && ip.charAt(tmp) == ':') {
                            return null;
                        }
                        needsShift = ++ipv6Seperators == 2 && value2 == 0;
                        compressBegin = currentIndex;
                        compressLength = bytes2.length - compressBegin - 2;
                        ++i;
                    }
                    value2 = 0;
                    begin = -1;
                    continue block6;
                }
                case '.': {
                    if (i - begin > 3 || ++ipv4Seperators > 3 || ipv6Seperators > 0 && currentIndex + compressLength < 12 || i + 1 >= ipLength || currentIndex >= bytes2.length || begin < 0 || begin == 0 && (i == 3 && (!NetUtil.isValidNumericChar(ip.charAt(2)) || !NetUtil.isValidNumericChar(ip.charAt(1)) || !NetUtil.isValidNumericChar(ip.charAt(0))) || i == 2 && (!NetUtil.isValidNumericChar(ip.charAt(1)) || !NetUtil.isValidNumericChar(ip.charAt(0))) || i == 1 && !NetUtil.isValidNumericChar(ip.charAt(0)))) {
                        return null;
                    }
                    if ((begin = ((value2 <<= 3 - (i - begin) << 2) & 0xF) * 100 + (value2 >> 4 & 0xF) * 10 + (value2 >> 8 & 0xF)) < 0 || begin > 255) {
                        return null;
                    }
                    bytes2[currentIndex++] = (byte)begin;
                    value2 = 0;
                    begin = -1;
                    continue block6;
                }
                default: {
                    if (!NetUtil.isValidHexChar(c) || ipv4Seperators > 0 && !NetUtil.isValidNumericChar(c)) {
                        return null;
                    }
                    if (begin < 0) {
                        begin = i;
                    } else if (i - begin > 4) {
                        return null;
                    }
                    value2 += NetUtil.getIntValue(c) << (i - begin << 2);
                }
            }
        }
        boolean bl = isCompressed = compressBegin > 0;
        if (ipv4Seperators > 0) {
            if (begin > 0 && i - begin > 3 || ipv4Seperators != 3 || currentIndex >= bytes2.length) {
                return null;
            }
            if (ipv6Seperators == 0) {
                compressLength = 12;
            } else if (ipv6Seperators >= 2 && ip.charAt(ipLength - 1) != ':' && (!isCompressed && ipv6Seperators == 6 && ip.charAt(0) != ':' || isCompressed && ipv6Seperators + 1 < 8 && (ip.charAt(0) != ':' || compressBegin <= 2))) {
                compressLength -= 2;
            } else {
                return null;
            }
            value2 <<= 3 - (i - begin) << 2;
            begin = (value2 & 0xF) * 100 + (value2 >> 4 & 0xF) * 10 + (value2 >> 8 & 0xF);
            if (begin < 0 || begin > 255) {
                return null;
            }
            bytes2[currentIndex++] = (byte)begin;
        } else {
            tmp = ipLength - 1;
            if (begin > 0 && i - begin > 4 || ipv6Seperators < 2 || !isCompressed && (ipv6Seperators + 1 != 8 || ip.charAt(0) == ':' || ip.charAt(tmp) == ':') || isCompressed && (ipv6Seperators > 8 || ipv6Seperators == 8 && (compressBegin <= 2 && ip.charAt(0) != ':' || compressBegin >= 14 && ip.charAt(tmp) != ':')) || currentIndex + 1 >= bytes2.length) {
                return null;
            }
            if (begin >= 0 && i - begin <= 4) {
                value2 <<= 4 - (i - begin) << 2;
            }
            bytes2[currentIndex++] = (byte)((value2 & 0xF) << 4 | value2 >> 4 & 0xF);
            bytes2[currentIndex++] = (byte)((value2 >> 8 & 0xF) << 4 | value2 >> 12 & 0xF);
        }
        i = currentIndex + compressLength;
        if (needsShift || i >= bytes2.length) {
            if (i >= bytes2.length) {
                ++compressBegin;
            }
            for (i = currentIndex; i < bytes2.length; ++i) {
                for (begin = bytes2.length - 1; begin >= compressBegin; --begin) {
                    bytes2[begin] = bytes2[begin - 1];
                }
                bytes2[begin] = 0;
                ++compressBegin;
            }
        } else {
            for (i = 0; i < compressLength && (currentIndex = (begin = i + compressBegin) + compressLength) < bytes2.length; ++i) {
                bytes2[currentIndex] = bytes2[begin];
                bytes2[begin] = 0;
            }
        }
        if (ipv4Mapped && ipv4Seperators > 0 && bytes2[0] == 0 && bytes2[1] == 0 && bytes2[2] == 0 && bytes2[3] == 0 && bytes2[4] == 0 && bytes2[5] == 0 && bytes2[6] == 0 && bytes2[7] == 0 && bytes2[8] == 0 && bytes2[9] == 0) {
            bytes2[11] = -1;
            bytes2[10] = -1;
        }
        try {
            return Inet6Address.getByAddress(null, bytes2, -1);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toAddressString(InetAddress ip) {
        return NetUtil.toAddressString(ip, false);
    }

    public static String toAddressString(InetAddress ip, boolean ipv4Mapped) {
        int i;
        if (ip instanceof Inet4Address) {
            return ip.getHostAddress();
        }
        if (!(ip instanceof Inet6Address)) {
            throw new IllegalArgumentException("Unhandled type: " + ip.getClass());
        }
        byte[] bytes2 = ip.getAddress();
        int[] words = new int[8];
        for (i = 0; i < words.length; ++i) {
            words[i] = (bytes2[i << 1] & 0xFF) << 8 | bytes2[(i << 1) + 1] & 0xFF;
        }
        int currentStart = -1;
        int currentLength = 0;
        int shortestStart = -1;
        int shortestLength = 0;
        for (i = 0; i < words.length; ++i) {
            if (words[i] == 0) {
                if (currentStart >= 0) continue;
                currentStart = i;
                continue;
            }
            if (currentStart < 0) continue;
            currentLength = i - currentStart;
            if (currentLength > shortestLength) {
                shortestStart = currentStart;
                shortestLength = currentLength;
            }
            currentStart = -1;
        }
        if (currentStart >= 0 && (currentLength = i - currentStart) > shortestLength) {
            shortestStart = currentStart;
            shortestLength = currentLength;
        }
        if (shortestLength == 1) {
            shortestLength = 0;
            shortestStart = -1;
        }
        int shortestEnd = shortestStart + shortestLength;
        StringBuilder b = new StringBuilder(39);
        if (shortestEnd < 0) {
            b.append(Integer.toHexString(words[0]));
            for (i = 1; i < words.length; ++i) {
                b.append(':');
                b.append(Integer.toHexString(words[i]));
            }
        } else {
            boolean isIpv4Mapped;
            if (NetUtil.inRangeEndExclusive(0, shortestStart, shortestEnd)) {
                b.append("::");
                isIpv4Mapped = ipv4Mapped && shortestEnd == 5 && words[5] == 65535;
            } else {
                b.append(Integer.toHexString(words[0]));
                isIpv4Mapped = false;
            }
            for (i = 1; i < words.length; ++i) {
                if (!NetUtil.inRangeEndExclusive(i, shortestStart, shortestEnd)) {
                    if (!NetUtil.inRangeEndExclusive(i - 1, shortestStart, shortestEnd)) {
                        if (!isIpv4Mapped || i == 6) {
                            b.append(':');
                        } else {
                            b.append('.');
                        }
                    }
                    if (isIpv4Mapped && i > 5) {
                        b.append(words[i] >> 8);
                        b.append('.');
                        b.append(words[i] & 0xFF);
                        continue;
                    }
                    b.append(Integer.toHexString(words[i]));
                    continue;
                }
                if (NetUtil.inRangeEndExclusive(i - 1, shortestStart, shortestEnd)) continue;
                b.append("::");
            }
        }
        return b.toString();
    }

    private static boolean inRangeEndExclusive(int value2, int start2, int end2) {
        return value2 >= start2 && value2 < end2;
    }

    private NetUtil() {
    }
}

