/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.internal.SystemPropertyUtil;

public final class NativeLibraryLoader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NativeLibraryLoader.class);
    private static final String NATIVE_RESOURCE_HOME = "META-INF/native/";
    private static final String OSNAME = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    private static final File WORKDIR;

    private static File tmpdir() {
        File f2;
        try {
            f2 = NativeLibraryLoader.toDirectory(SystemPropertyUtil.get("io.netty.tmpdir"));
            if (f2 != null) {
                logger.debug("-Dio.netty.tmpdir: " + f2);
                return f2;
            }
            f2 = NativeLibraryLoader.toDirectory(SystemPropertyUtil.get("java.io.tmpdir"));
            if (f2 != null) {
                logger.debug("-Dio.netty.tmpdir: " + f2 + " (java.io.tmpdir)");
                return f2;
            }
            if (NativeLibraryLoader.isWindows()) {
                f2 = NativeLibraryLoader.toDirectory(System.getenv("TEMP"));
                if (f2 != null) {
                    logger.debug("-Dio.netty.tmpdir: " + f2 + " (%TEMP%)");
                    return f2;
                }
                String userprofile = System.getenv("USERPROFILE");
                if (userprofile != null) {
                    f2 = NativeLibraryLoader.toDirectory(userprofile + "\\AppData\\Local\\Temp");
                    if (f2 != null) {
                        logger.debug("-Dio.netty.tmpdir: " + f2 + " (%USERPROFILE%\\AppData\\Local\\Temp)");
                        return f2;
                    }
                    f2 = NativeLibraryLoader.toDirectory(userprofile + "\\Local Settings\\Temp");
                    if (f2 != null) {
                        logger.debug("-Dio.netty.tmpdir: " + f2 + " (%USERPROFILE%\\Local Settings\\Temp)");
                        return f2;
                    }
                }
            } else {
                f2 = NativeLibraryLoader.toDirectory(System.getenv("TMPDIR"));
                if (f2 != null) {
                    logger.debug("-Dio.netty.tmpdir: " + f2 + " ($TMPDIR)");
                    return f2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        f2 = NativeLibraryLoader.isWindows() ? new File("C:\\Windows\\Temp") : new File("/tmp");
        logger.warn("Failed to get the temporary directory; falling back to: " + f2);
        return f2;
    }

    private static File toDirectory(String path2) {
        if (path2 == null) {
            return null;
        }
        File f2 = new File(path2);
        if (!f2.exists()) {
            f2.mkdirs();
        }
        if (!f2.isDirectory()) {
            return null;
        }
        try {
            return f2.getAbsoluteFile();
        }
        catch (Exception ignored) {
            return f2;
        }
    }

    private static boolean isWindows() {
        return OSNAME.startsWith("windows");
    }

    private static boolean isOSX() {
        return OSNAME.startsWith("macosx") || OSNAME.startsWith("osx");
    }

    /*
     * Loose catch block
     */
    public static void load(String name2, ClassLoader loader) {
        block25: {
            IOException ignore222;
            boolean loaded;
            File tmpFile;
            OutputStream out;
            InputStream in;
            block23: {
                int length;
                String libname = System.mapLibraryName(name2);
                String path2 = NATIVE_RESOURCE_HOME + libname;
                URL url = loader.getResource(path2);
                if (url == null && NativeLibraryLoader.isOSX()) {
                    url = path2.endsWith(".jnilib") ? loader.getResource("META-INF/native/lib" + name2 + ".dynlib") : loader.getResource("META-INF/native/lib" + name2 + ".jnilib");
                }
                if (url == null) {
                    System.loadLibrary(name2);
                    return;
                }
                int index2 = libname.lastIndexOf(46);
                String prefix = libname.substring(0, index2);
                String suffix = libname.substring(index2, libname.length());
                in = null;
                out = null;
                tmpFile = null;
                loaded = false;
                tmpFile = File.createTempFile(prefix, suffix, WORKDIR);
                in = url.openStream();
                out = new FileOutputStream(tmpFile);
                byte[] buffer2 = new byte[8192];
                while ((length = in.read(buffer2)) > 0) {
                    out.write(buffer2, 0, length);
                }
                out.flush();
                out.close();
                out = null;
                System.load(tmpFile.getPath());
                loaded = true;
                Object var15_15 = null;
                if (in == null) break block23;
                try {
                    in.close();
                }
                catch (IOException ignore222) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore222) {
                    // empty catch block
                }
            }
            if (tmpFile == null) break block25;
            if (loaded) {
                tmpFile.deleteOnExit();
            } else if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
            break block25;
            {
                catch (Exception e) {
                    throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("could not load a native library: " + name2).initCause(e);
                }
            }
            catch (Throwable throwable) {
                IOException ignore222;
                Object var15_16 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore222) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ignore222) {
                        // empty catch block
                    }
                }
                if (tmpFile != null) {
                    if (loaded) {
                        tmpFile.deleteOnExit();
                    } else if (!tmpFile.delete()) {
                        tmpFile.deleteOnExit();
                    }
                }
                throw throwable;
            }
        }
    }

    private NativeLibraryLoader() {
    }

    static {
        String workdir = SystemPropertyUtil.get("io.netty.native.workdir");
        if (workdir != null) {
            File f2 = new File(workdir);
            if (!f2.exists()) {
                f2.mkdirs();
            }
            try {
                f2 = f2.getAbsoluteFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            WORKDIR = f2;
            logger.debug("-Dio.netty.netty.workdir: " + WORKDIR);
        } else {
            WORKDIR = NativeLibraryLoader.tmpdir();
            logger.debug("-Dio.netty.netty.workdir: " + WORKDIR + " (io.netty.tmpdir)");
        }
    }
}

