/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert.factory;

import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;

public final class BooleanObjectArrayStringConverterFactory
implements StringConverterFactory {
    public static final StringConverterFactory INSTANCE = new BooleanObjectArrayStringConverterFactory();

    private BooleanObjectArrayStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        if (cls == Boolean[].class) {
            return BooleanArrayStringConverter.INSTANCE;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static enum BooleanArrayStringConverter implements StringConverter<Boolean[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Boolean[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length);
                for (int i = 0; i < array.length; ++i) {
                    buf.append((char)(array[i] == null ? 45 : (array[i] != false ? 84 : 70)));
                }
                return buf.toString();
            }

            @Override
            public Boolean[] convertFromString(Class<? extends Boolean[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                Boolean[] array = new Boolean[str.length()];
                for (int i = 0; i < array.length; ++i) {
                    char ch = str.charAt(i);
                    if (ch == 'T') {
                        array[i] = Boolean.TRUE;
                        continue;
                    }
                    if (ch == 'F') {
                        array[i] = Boolean.FALSE;
                        continue;
                    }
                    if (ch == '-') {
                        array[i] = null;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid Boolean[] string, must consist only of 'T', 'F' and '-'");
                }
                return array;
            }
        };

        private static final Boolean[] EMPTY;

        static {
            EMPTY = new Boolean[0];
        }
    }
}

