/*
 * Decompiled with CFR 0.152.
 */
package play;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import play.api.Play;
import play.libs.Scala;
import scala.Option;
import scala.collection.JavaConverters;

public class Configuration {
    private final play.api.Configuration conf;

    public static Configuration root() {
        return new Configuration(Play.unsafeApplication().configuration());
    }

    public Configuration(Config config2) {
        this(new play.api.Configuration(config2));
    }

    public Configuration(play.api.Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConfig(String string2) {
        Option<play.api.Configuration> option = this.conf.getConfig(string2);
        if (option.isDefined()) {
            return new Configuration(option.get());
        }
        return null;
    }

    public String getString(String string2) {
        return Scala.orNull(this.conf.getString(string2, Option.<scala.collection.immutable.Set<String>>empty()));
    }

    public String getString(String string2, String string3) {
        return Scala.orElse(this.conf.getString(string2, Option.<scala.collection.immutable.Set<String>>empty()), string3);
    }

    public Long getMilliseconds(String string2) {
        return (Long)Scala.orNull(this.conf.getMilliseconds(string2));
    }

    public Long getMilliseconds(String string2, Long l) {
        return Scala.orElse(this.conf.getMilliseconds(string2), l);
    }

    public Long getNanoseconds(String string2) {
        return (Long)Scala.orNull(this.conf.getNanoseconds(string2));
    }

    public Long getNanoseconds(String string2, Long l) {
        return Scala.orElse(this.conf.getNanoseconds(string2), l);
    }

    public Long getBytes(String string2) {
        return (Long)Scala.orNull(this.conf.getBytes(string2));
    }

    public Long getBytes(String string2, Long l) {
        return Scala.orElse(this.conf.getBytes(string2), l);
    }

    public Double getDouble(String string2) {
        return (Double)Scala.orNull(this.conf.getDouble(string2));
    }

    public Double getDouble(String string2, Double d) {
        return Scala.orElse(this.conf.getDouble(string2), d);
    }

    public Integer getInt(String string2) {
        return (Integer)Scala.orNull(this.conf.getInt(string2));
    }

    public Integer getInt(String string2, Integer n) {
        return Scala.orElse(this.conf.getInt(string2), n);
    }

    public Long getLong(String string2) {
        return (Long)Scala.orNull(this.conf.getLong(string2));
    }

    public Long getLong(String string2, Long l) {
        return Scala.orElse(this.conf.getLong(string2), l);
    }

    public Number getNumber(String string2) {
        return Scala.orNull(this.conf.getNumber(string2));
    }

    public Number getNumber(String string2, Number number2) {
        return Scala.orElse(this.conf.getNumber(string2), number2);
    }

    public Boolean getBoolean(String string2) {
        return (Boolean)Scala.orNull(this.conf.getBoolean(string2));
    }

    public Boolean getBoolean(String string2, Boolean bl) {
        return Scala.orElse(this.conf.getBoolean(string2), bl);
    }

    public Set<String> keys() {
        return JavaConverters.setAsJavaSetConverter(this.conf.keys()).asJava();
    }

    public Set<String> subKeys() {
        return JavaConverters.setAsJavaSetConverter(this.conf.subKeys()).asJava();
    }

    public Map<String, Object> asMap() {
        return this.conf.underlying().root().unwrapped();
    }

    public Config underlying() {
        return this.conf.underlying();
    }

    public Set<Map.Entry<String, ConfigValue>> entrySet() {
        return this.conf.underlying().entrySet();
    }

    public RuntimeException reportError(String string2, String string3, Throwable throwable) {
        return this.conf.reportError(string2, string3, Option.apply(throwable));
    }

    public List<Boolean> getBooleanList(String string2) {
        return Scala.orNull(this.conf.getBooleanList(string2));
    }

    public List<Boolean> getBooleanList(String string2, List<Boolean> list2) {
        return Scala.orElse(this.conf.getBooleanList(string2), list2);
    }

    public List<Long> getBytesList(String string2) {
        return Scala.orNull(this.conf.getBytesList(string2));
    }

    public List<Long> getBytesList(String string2, List<Long> list2) {
        return Scala.orElse(this.conf.getBytesList(string2), list2);
    }

    public List<Configuration> getConfigList(String string2) {
        if (this.conf.getConfigList(string2).isDefined()) {
            ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
            for (play.api.Configuration configuration : this.conf.getConfigList(string2).get()) {
                arrayList.add(new Configuration(configuration));
            }
            return arrayList;
        }
        return null;
    }

    public List<Configuration> getConfigList(String string2, List<Configuration> list2) {
        List<Configuration> list3 = this.getConfigList(string2);
        if (list3 == null) {
            list3 = list2;
        }
        return list3;
    }

    public List<Double> getDoubleList(String string2) {
        return Scala.orNull(this.conf.getDoubleList(string2));
    }

    public List<Double> getDoubleList(String string2, List<Double> list2) {
        return Scala.orElse(this.conf.getDoubleList(string2), list2);
    }

    public List<Integer> getIntList(String string2) {
        return Scala.orNull(this.conf.getIntList(string2));
    }

    public List<Integer> getIntList(String string2, List<Integer> list2) {
        return Scala.orElse(this.conf.getIntList(string2), list2);
    }

    public List<Object> getList(String string2) {
        if (this.conf.getList(string2).isDefined()) {
            return this.conf.getList(string2).get().unwrapped();
        }
        return null;
    }

    public List<Object> getList(String string2, List<Object> list2) {
        List<Object> list3 = this.getList(string2);
        if (list3 == null) {
            list3 = list2;
        }
        return list3;
    }

    public List<Long> getLongList(String string2) {
        return Scala.orNull(this.conf.getLongList(string2));
    }

    public List<Long> getLongList(String string2, List<Long> list2) {
        return Scala.orElse(this.conf.getLongList(string2), list2);
    }

    public List<Long> getMillisecondsList(String string2) {
        return Scala.orNull(this.conf.getMillisecondsList(string2));
    }

    public List<Long> getMillisecondsList(String string2, List<Long> list2) {
        return Scala.orElse(this.conf.getMillisecondsList(string2), list2);
    }

    public List<Long> getNanosecondsList(String string2) {
        return Scala.orNull(this.conf.getNanosecondsList(string2));
    }

    public List<Long> getNanosecondsList(String string2, List<Long> list2) {
        return Scala.orElse(this.conf.getNanosecondsList(string2), list2);
    }

    public List<Number> getNumberList(String string2) {
        return Scala.orNull(this.conf.getNumberList(string2));
    }

    public List<Number> getNumberList(String string2, List<Number> list2) {
        return Scala.orElse(this.conf.getNumberList(string2), list2);
    }

    public List<Map<String, Object>> getObjectList(String string2) {
        if (this.conf.getObjectList(string2).isDefined()) {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            for (ConfigObject configObject : this.conf.getObjectList(string2).get()) {
                arrayList.add(configObject.unwrapped());
            }
            return arrayList;
        }
        return null;
    }

    public List<Map<String, Object>> getObjectList(String string2, List<Map<String, Object>> list2) {
        List<Map<String, Object>> list3 = this.getObjectList(string2);
        if (list3 == null) {
            list3 = list2;
        }
        return list3;
    }

    public List<String> getStringList(String string2) {
        return Scala.orNull(this.conf.getStringList(string2));
    }

    public List<String> getStringList(String string2, List<String> list2) {
        return Scala.orElse(this.conf.getStringList(string2), list2);
    }

    public Object getObject(String string2) {
        if (this.conf.getObject(string2).isDefined()) {
            return this.conf.getObject(string2).get().unwrapped();
        }
        return null;
    }

    public Object getObject(String string2, Object object) {
        Object object2 = this.getObject(string2);
        if (object2 == null) {
            object2 = object;
        }
        return object2;
    }

    public play.api.Configuration getWrappedConfiguration() {
        return this.conf;
    }
}

