/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import java.io.File;
import java.net.URL;
import java.util.List;
import play.api.Application;
import play.api.Configuration;
import play.api.Mode$;
import play.api.Play$;
import play.api.PlayException;
import play.utils.PlayIO$;
import scala.Enumeration;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class Configuration$
implements Serializable {
    public static final Configuration$ MODULE$;
    private ConfigParseOptions dontAllowMissingConfigOptions;
    private Config dontAllowMissingConfig;
    private volatile byte bitmap$0;

    static {
        new Configuration$();
    }

    private ConfigParseOptions dontAllowMissingConfigOptions$lzycompute() {
        Configuration$ configuration$ = this;
        synchronized (configuration$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dontAllowMissingConfigOptions = ConfigParseOptions.defaults().setAllowMissing(false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.dontAllowMissingConfigOptions;
        }
    }

    private Config dontAllowMissingConfig$lzycompute() {
        Configuration$ configuration$ = this;
        synchronized (configuration$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dontAllowMissingConfig = ConfigFactory.load(this.dontAllowMissingConfigOptions());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.dontAllowMissingConfig;
        }
    }

    private ConfigParseOptions dontAllowMissingConfigOptions() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.dontAllowMissingConfigOptions$lzycompute() : this.dontAllowMissingConfigOptions;
    }

    private Config dontAllowMissingConfig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dontAllowMissingConfig$lzycompute() : this.dontAllowMissingConfig;
    }

    public Config loadDev(File appPath, Map<String, String> devSettings) {
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        try {
            ObjectRef<Object> file$lzy = ObjectRef.zero();
            Config config2 = Option$.MODULE$.apply(System.getProperty("config.resource")).map(new Serializable(){

                public final Config apply(String x$1) {
                    return ConfigFactory.parseResources(x$1);
                }
            }).getOrElse(new Serializable(appPath, devSettings, file$lzy, bitmap$0){
                private final File appPath$1;
                private final Map devSettings$1;
                private final ObjectRef file$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final Config apply() {
                    return ConfigFactory.parseFileAnySyntax(Configuration$.MODULE$.play$api$Configuration$$file$1(this.appPath$1, this.devSettings$1, this.file$lzy$1, this.bitmap$0$1));
                }
                {
                    this.appPath$1 = appPath$1;
                    this.devSettings$1 = devSettings$1;
                    this.file$lzy$1 = file$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
            return ConfigFactory.parseMap(JavaConverters$.MODULE$.mapAsJavaMapConverter(devSettings).asJava()).withFallback(ConfigFactory.load(config2));
        }
        catch (ConfigException configException) {
            throw this.play$api$Configuration$$configError(configException.origin(), configException.getMessage(), new Some<Throwable>(configException));
        }
    }

    public Configuration load(File appPath, Enumeration.Value mode, Map<String, String> devSettings) {
        try {
            Enumeration.Value currentMode;
            Enumeration.Value value2 = currentMode = Play$.MODULE$.maybeApplication().map(new Serializable(){

                public final Enumeration.Value apply(Application x$2) {
                    return x$2.mode();
                }
            }).getOrElse(new Serializable(mode){
                private final Enumeration.Value mode$1;

                public final Enumeration.Value apply() {
                    return this.mode$1;
                }
                {
                    this.mode$1 = mode$1;
                }
            });
            Enumeration.Value value3 = Mode$.MODULE$.Prod();
            return !(value2 != null ? !((Object)value2).equals(value3) : value3 != null) ? new Configuration(this.dontAllowMissingConfig()) : new Configuration(this.loadDev(appPath, devSettings));
        }
        catch (ConfigException configException) {
            throw this.play$api$Configuration$$configError(configException.origin(), configException.getMessage(), new Some<Throwable>(configException));
        }
    }

    public Enumeration.Value load$default$2() {
        return Mode$.MODULE$.Dev();
    }

    public Map<String, String> load$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Configuration empty() {
        return new Configuration(ConfigFactory.empty());
    }

    public Configuration from(Map<String, Object> data) {
        return new Configuration(ConfigFactory.parseMap(JavaConverters$.MODULE$.mapAsJavaMapConverter(this.play$api$Configuration$$asJavaRecursively$1(data)).asJava()));
    }

    public PlayException play$api$Configuration$$configError(ConfigOrigin origin, String message, Option<Throwable> e) {
        return new PlayException.ExceptionSource(origin, message, e){
            private final ConfigOrigin origin$1;

            public Integer line() {
                return (Integer)Option$.MODULE$.apply(Predef$.MODULE$.int2Integer(this.origin$1.lineNumber())).orNull(Predef$.MODULE$.$conforms());
            }

            public Null$ position() {
                return null;
            }

            public String input() {
                return (String)Option$.MODULE$.apply(this.origin$1.url()).map(new Serializable(this){

                    public final String apply(URL url) {
                        return PlayIO$.MODULE$.readUrlAsString(url, Codec$.MODULE$.fallbackSystemCodec());
                    }
                }).orNull(Predef$.MODULE$.$conforms());
            }

            public String sourceName() {
                return (String)Option$.MODULE$.apply(this.origin$1.filename()).orNull(Predef$.MODULE$.$conforms());
            }

            public String toString() {
                return new StringBuilder().append((Object)"Configuration error: ").append((Object)this.getMessage()).toString();
            }
            {
                this.origin$1 = origin$1;
                super("Configuration error", message$1, (Throwable)e$1.orNull(Predef$.MODULE$.$conforms()));
            }
        };
    }

    private Option<Throwable> configError$default$3() {
        return None$.MODULE$;
    }

    public <A> Seq<A> asScalaList(List<A> l) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(l).asScala()).toList();
    }

    public Configuration apply(Config underlying) {
        return new Configuration(underlying);
    }

    public Option<Config> unapply(Configuration x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Config>(x$0.underlying());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final File file$lzycompute$1(File appPath$1, Map devSettings$1, ObjectRef file$lzy$1, VolatileByteRef bitmap$0$1) {
        Configuration$ configuration$ = this;
        synchronized (configuration$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                file$lzy$1.elem = devSettings$1.get("config.file").orElse(new Serializable(){

                    public final Option<String> apply() {
                        return Option$.MODULE$.apply(System.getProperty("config.file"));
                    }
                }).map(new Serializable(){

                    public final File apply(String f2) {
                        return new File(f2);
                    }
                }).getOrElse(new Serializable(appPath$1){
                    private final File appPath$1;

                    public final File apply() {
                        return new File(this.appPath$1, "conf/application.conf");
                    }
                    {
                        this.appPath$1 = appPath$1;
                    }
                });
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (File)file$lzy$1.elem;
        }
    }

    public final File play$api$Configuration$$file$1(File appPath$1, Map devSettings$1, ObjectRef file$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.file$lzycompute$1(appPath$1, devSettings$1, file$lzy$1, bitmap$0$1) : (File)file$lzy$1.elem;
    }

    public final Map play$api$Configuration$$asJavaRecursively$1(Map data) {
        return data.mapValues(new Serializable(){

            public final Object apply(Object value2) {
                Object object;
                java.util.Map<A, B> map2 = value2;
                if (map2 instanceof Map) {
                    Map map3 = (Map)((Object)map2);
                    object = JavaConverters$.MODULE$.mapAsJavaMapConverter(Configuration$.MODULE$.play$api$Configuration$$asJavaRecursively$1(map3)).asJava();
                } else if (map2 instanceof Iterable) {
                    Iterable iterable = (Iterable)((Object)map2);
                    object = JavaConverters$.MODULE$.asJavaIterableConverter(iterable).asJava();
                } else {
                    object = map2;
                }
                return object;
            }
        });
    }

    private Configuration$() {
        MODULE$ = this;
    }
}

