/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ssl;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.Instant;
import scala.collection.mutable.StringBuilder;
import scala.util.Properties$;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class CertificateGenerator$ {
    public static final CertificateGenerator$ MODULE$;

    static {
        new CertificateGenerator$();
    }

    public X509Certificate generateRSAWithSHA256(int keySize, Instant from2, int duration) {
        String dn = "CN=localhost, OU=Unit Testing, O=Mavericks, L=Moon Base 1, ST=Cyberspace, C=CY";
        Instant to2 = from2.plus(duration);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(keySize, new SecureRandom());
        KeyPair pair2 = keyGen.generateKeyPair();
        return this.generateCertificate(dn, pair2, from2.toDate(), to2.toDate(), "SHA256WithRSA", AlgorithmId.sha256WithRSAEncryption_oid);
    }

    public int generateRSAWithSHA256$default$1() {
        return 2048;
    }

    public Instant generateRSAWithSHA256$default$2() {
        return Instant.now();
    }

    public int generateRSAWithSHA256$default$3() {
        return 5000000;
    }

    public String toPEM(X509Certificate certificate) {
        Base64 encoder = new Base64(64);
        String certBegin = "-----BEGIN CERTIFICATE-----\n";
        String certEnd = "-----END CERTIFICATE-----";
        byte[] derCert = certificate.getEncoded();
        String pemCertPre = new String(encoder.encode(derCert), "UTF-8");
        String pemCert = new StringBuilder().append((Object)certBegin).append((Object)pemCertPre).append((Object)certEnd).toString();
        return pemCert;
    }

    public X509Certificate generateRSAWithMD5(int keySize, Instant from2, int duration) {
        String dn = "CN=localhost, OU=Unit Testing, O=Mavericks, L=Moon Base 1, ST=Cyberspace, C=CY";
        Instant to2 = from2.plus(duration);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(keySize, new SecureRandom());
        KeyPair pair2 = keyGen.generateKeyPair();
        return this.generateCertificate(dn, pair2, from2.toDate(), to2.toDate(), "MD5WithRSA", AlgorithmId.md5WithRSAEncryption_oid);
    }

    public int generateRSAWithMD5$default$1() {
        return 2048;
    }

    public Instant generateRSAWithMD5$default$2() {
        return Instant.now();
    }

    public int generateRSAWithMD5$default$3() {
        return 5000000;
    }

    public X509Certificate generateCertificate(String dn, KeyPair pair2, Date from2, Date to2, String algorithm2, ObjectIdentifier oid) {
        X509CertInfo info2 = new X509CertInfo();
        CertificateValidity interval = new CertificateValidity(from2, to2);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        X500Name owner2 = new X500Name(dn);
        boolean justName = Properties$.MODULE$.isJavaAtLeast("1.8");
        info2.set("validity", interval);
        info2.set("serialNumber", new CertificateSerialNumber(sn));
        info2.set("subject", justName ? owner2 : new CertificateSubjectName(owner2));
        info2.set("issuer", justName ? owner2 : new CertificateIssuerName(owner2));
        info2.set("key", new CertificateX509Key(pair2.getPublic()));
        info2.set("version", new CertificateVersion(2));
        AlgorithmId algo = new AlgorithmId(oid);
        info2.set("algorithmID", new CertificateAlgorithmId(algo));
        X509CertImpl cert = new X509CertImpl(info2);
        PrivateKey privkey = pair2.getPrivate();
        cert.sign(privkey, algorithm2);
        algo = (AlgorithmId)cert.get("x509.algorithm");
        info2.set("algorithmID.algorithm", algo);
        cert = new X509CertImpl(info2);
        cert.sign(privkey, algorithm2);
        return cert;
    }

    private CertificateGenerator$() {
        MODULE$ = this;
    }
}

