/*
 * Decompiled with CFR 0.152.
 */
package play.core.classloader;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import play.api.PlayException;
import play.api.UsefulException;
import play.core.BuildDocHandler;
import play.core.BuildLink;
import play.core.classloader.ApplicationClassLoaderProvider;
import play.core.server.ServerWithStop;

public class DelegatingClassLoader
extends ClassLoader {
    private static final List<String> buildSharedClasses;
    private ClassLoader buildLoader;
    private ApplicationClassLoaderProvider applicationClassLoaderProvider;

    public DelegatingClassLoader(ClassLoader classLoader, ClassLoader classLoader2, ApplicationClassLoaderProvider applicationClassLoaderProvider) {
        super(classLoader);
        this.buildLoader = classLoader2;
        this.applicationClassLoaderProvider = applicationClassLoaderProvider;
    }

    public static boolean isSharedClass(String string2) {
        return buildSharedClasses.contains(string2);
    }

    @Override
    public Class<?> loadClass(String string2, boolean bl) throws ClassNotFoundException {
        if (DelegatingClassLoader.isSharedClass(string2)) {
            return this.buildLoader.loadClass(string2);
        }
        return super.loadClass(string2, bl);
    }

    @Override
    public URL getResource(String string2) {
        Method method;
        try {
            method = ClassLoader.class.getDeclaredMethod("findResource", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        method.setAccessible(true);
        ClassLoader classLoader = this.applicationClassLoaderProvider.get();
        URL uRL = null;
        if (classLoader != null) {
            try {
                uRL = (URL)method.invoke((Object)classLoader, string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalStateException(invocationTargetException);
            }
        }
        return uRL != null ? uRL : super.getResource(string2);
    }

    @Override
    public Enumeration<URL> getResources(String string2) throws IOException {
        Enumeration enumeration;
        Method method;
        try {
            method = ClassLoader.class.getDeclaredMethod("findResources", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        method.setAccessible(true);
        ClassLoader classLoader = this.applicationClassLoaderProvider.get();
        if (classLoader != null) {
            try {
                enumeration = (Enumeration)method.invoke((Object)classLoader, string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalStateException(invocationTargetException);
            }
        } else {
            enumeration = new Vector().elements();
        }
        Enumeration<URL> enumeration2 = super.getResources(string2);
        return this.combineResources(enumeration, enumeration2);
    }

    private Enumeration<URL> combineResources(Enumeration<URL> enumeration, Enumeration<URL> enumeration2) {
        HashSet<URL> hashSet = new HashSet<URL>();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        while (enumeration2.hasMoreElements()) {
            hashSet.add(enumeration2.nextElement());
        }
        return new Vector(hashSet).elements();
    }

    public String toString() {
        return "DelegatingClassLoader, using parent: " + this.getParent();
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(BuildLink.class.getName());
        arrayList.add(BuildDocHandler.class.getName());
        arrayList.add(ServerWithStop.class.getName());
        arrayList.add(UsefulException.class.getName());
        arrayList.add(PlayException.class.getName());
        arrayList.add(PlayException.InterestingLines.class.getName());
        arrayList.add(PlayException.RichDescription.class.getName());
        arrayList.add(PlayException.ExceptionSource.class.getName());
        arrayList.add(PlayException.ExceptionAttachment.class.getName());
        buildSharedClasses = Collections.unmodifiableList(arrayList);
    }
}

