/*
 * Decompiled with CFR 0.152.
 */
package play.core.enhancers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.MemberValue;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;

public class PropertiesEnhancer {
    public static boolean generateAccessors(String string2, File file2) throws Exception {
        ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        classPool.appendPathList(string2);
        FileInputStream fileInputStream = new FileInputStream(file2);
        try {
            CtClass ctClass = classPool.makeClass(fileInputStream);
            if (PropertiesEnhancer.hasAnnotation(ctClass, GeneratedAccessor.class)) {
                fileInputStream.close();
                return false;
            }
            for (CtField ctField : ctClass.getDeclaredFields()) {
                String string3;
                String string4;
                CtMethod ctMethod;
                CtMethod ctMethod2;
                SignatureAttribute signatureAttribute;
                String string5;
                block11: {
                    if (!PropertiesEnhancer.isProperty(ctField)) continue;
                    String string6 = ctField.getName().substring(0, 1).toUpperCase() + ctField.getName().substring(1);
                    String string7 = "get" + string6;
                    string5 = "set" + string6;
                    signatureAttribute = (SignatureAttribute)ctField.getFieldInfo().getAttribute("Signature");
                    try {
                        ctMethod2 = ctClass.getDeclaredMethod(string7);
                        if (ctMethod2.getParameterTypes().length > 0 || Modifier.isStatic(ctMethod2.getModifiers())) {
                            throw new NotFoundException("it's not a getter !");
                        }
                    }
                    catch (NotFoundException notFoundException) {
                        ctMethod = CtMethod.make("public " + ctField.getType().getName() + " " + string7 + "() { return this." + ctField.getName() + "; }", ctClass);
                        ctClass.addMethod(ctMethod);
                        PropertiesEnhancer.createAnnotation(PropertiesEnhancer.getAnnotations(ctMethod), GeneratedAccessor.class);
                        PropertiesEnhancer.createAnnotation(PropertiesEnhancer.getAnnotations(ctField), GeneratedGetAccessor.class);
                        if (signatureAttribute == null) break block11;
                        string4 = signatureAttribute.getSignature();
                        string3 = "()" + string4;
                        ctMethod.getMethodInfo().addAttribute(new SignatureAttribute(ctMethod.getMethodInfo().getConstPool(), string3));
                    }
                }
                try {
                    ctMethod2 = ctClass.getDeclaredMethod(string5);
                    if (ctMethod2.getParameterTypes().length == 1 && ctMethod2.getParameterTypes()[0].equals(ctField.getType()) && !Modifier.isStatic(ctMethod2.getModifiers())) continue;
                    throw new NotFoundException("it's not a setter !");
                }
                catch (NotFoundException notFoundException) {
                    ctMethod = CtMethod.make("public void " + string5 + "(" + ctField.getType().getName() + " value) { this." + ctField.getName() + " = value; }", ctClass);
                    ctClass.addMethod(ctMethod);
                    PropertiesEnhancer.createAnnotation(PropertiesEnhancer.getAnnotations(ctMethod), GeneratedAccessor.class);
                    PropertiesEnhancer.createAnnotation(PropertiesEnhancer.getAnnotations(ctField), GeneratedSetAccessor.class);
                    if (signatureAttribute == null) continue;
                    string4 = signatureAttribute.getSignature();
                    string3 = "(" + string4 + ")V";
                    ctMethod.getMethodInfo().addAttribute(new SignatureAttribute(ctMethod.getMethodInfo().getConstPool(), string3));
                }
            }
            PropertiesEnhancer.createAnnotation(PropertiesEnhancer.getAnnotations(ctClass), GeneratedAccessor.class);
            fileInputStream.close();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(ctClass.toBytecode());
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            fileInputStream.close();
            throw exception;
        }
    }

    public static boolean rewriteAccess(String string2, File file2) throws Exception {
        ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        classPool.appendPathList(string2);
        FileInputStream fileInputStream = new FileInputStream(file2);
        try {
            CtClass ctClass = classPool.makeClass(fileInputStream);
            if (PropertiesEnhancer.hasAnnotation(ctClass, RewrittenAccessor.class)) {
                fileInputStream.close();
                return false;
            }
            for (final CtBehavior ctBehavior : ctClass.getDeclaredBehaviors()) {
                ctBehavior.instrument(new ExprEditor(){

                    @Override
                    public void edit(FieldAccess fieldAccess) throws CannotCompileException {
                        try {
                            if (PropertiesEnhancer.isAccessor(fieldAccess.getField())) {
                                String string2 = null;
                                if ((fieldAccess.getField().getDeclaringClass().equals(ctBehavior.getDeclaringClass()) || ctBehavior.getDeclaringClass().subclassOf(fieldAccess.getField().getDeclaringClass())) && (ctBehavior.getName().startsWith("get") || ctBehavior.getName().startsWith("set")) && ctBehavior.getName().length() > 3) {
                                    string2 = ctBehavior.getName().substring(3);
                                    string2 = string2.substring(0, 1).toLowerCase() + string2.substring(1);
                                }
                                if (string2 == null || !string2.equals(fieldAccess.getFieldName())) {
                                    String string3 = fieldAccess.getFieldName().substring(0, 1).toUpperCase() + fieldAccess.getFieldName().substring(1);
                                    if (fieldAccess.isReader() && PropertiesEnhancer.hasAnnotation(fieldAccess.getField(), GeneratedGetAccessor.class)) {
                                        fieldAccess.replace("$_ = $0.get" + string3 + "();");
                                    } else if (fieldAccess.isWriter() && PropertiesEnhancer.hasAnnotation(fieldAccess.getField(), GeneratedSetAccessor.class)) {
                                        fieldAccess.replace("$0.set" + string3 + "($1);");
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            PropertiesEnhancer.createAnnotation(PropertiesEnhancer.getAnnotations(ctClass), RewrittenAccessor.class);
            fileInputStream.close();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(ctClass.toBytecode());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            fileInputStream.close();
            throw exception;
        }
        return true;
    }

    static boolean isProperty(CtField ctField) {
        if (ctField.getName().equals(ctField.getName().toUpperCase()) || ctField.getName().substring(0, 1).equals(ctField.getName().substring(0, 1).toUpperCase())) {
            return false;
        }
        return Modifier.isPublic(ctField.getModifiers()) && !Modifier.isFinal(ctField.getModifiers()) && !Modifier.isStatic(ctField.getModifiers());
    }

    static boolean isAccessor(CtField ctField) throws Exception {
        return PropertiesEnhancer.hasAnnotation(ctField, GeneratedGetAccessor.class) || PropertiesEnhancer.hasAnnotation(ctField, GeneratedSetAccessor.class);
    }

    static boolean hasAnnotation(CtClass ctClass, Class<? extends Annotation> clazz) throws ClassNotFoundException {
        return PropertiesEnhancer.getAnnotations(ctClass).getAnnotation(clazz.getName()) != null;
    }

    static boolean hasAnnotation(CtField ctField, Class<? extends Annotation> clazz) throws ClassNotFoundException {
        return PropertiesEnhancer.getAnnotations(ctField).getAnnotation(clazz.getName()) != null;
    }

    static AnnotationsAttribute getAnnotations(CtClass ctClass) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        if (annotationsAttribute == null) {
            annotationsAttribute = new AnnotationsAttribute(ctClass.getClassFile().getConstPool(), "RuntimeVisibleAnnotations");
            ctClass.getClassFile().addAttribute(annotationsAttribute);
        }
        return annotationsAttribute;
    }

    static AnnotationsAttribute getAnnotations(CtField ctField) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)ctField.getFieldInfo().getAttribute("RuntimeVisibleAnnotations");
        if (annotationsAttribute == null) {
            annotationsAttribute = new AnnotationsAttribute(ctField.getFieldInfo().getConstPool(), "RuntimeVisibleAnnotations");
            ctField.getFieldInfo().addAttribute(annotationsAttribute);
        }
        return annotationsAttribute;
    }

    static AnnotationsAttribute getAnnotations(CtMethod ctMethod) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)ctMethod.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
        if (annotationsAttribute == null) {
            annotationsAttribute = new AnnotationsAttribute(ctMethod.getMethodInfo().getConstPool(), "RuntimeVisibleAnnotations");
            ctMethod.getMethodInfo().addAttribute(annotationsAttribute);
        }
        return annotationsAttribute;
    }

    static void createAnnotation(AnnotationsAttribute annotationsAttribute, Class<? extends Annotation> clazz, Map<String, MemberValue> map2) {
        javassist.bytecode.annotation.Annotation annotation = new javassist.bytecode.annotation.Annotation(clazz.getName(), annotationsAttribute.getConstPool());
        for (Map.Entry<String, MemberValue> entry : map2.entrySet()) {
            annotation.addMemberValue(entry.getKey(), entry.getValue());
        }
        annotationsAttribute.addAnnotation(annotation);
    }

    static void createAnnotation(AnnotationsAttribute annotationsAttribute, Class<? extends Annotation> clazz) {
        PropertiesEnhancer.createAnnotation(annotationsAttribute, clazz, new HashMap<String, MemberValue>());
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RewrittenAccessor {
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface GeneratedSetAccessor {
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface GeneratedGetAccessor {
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface GeneratedAccessor {
    }
}

