/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import play.api.Play$;
import play.core.ApplicationProvider;
import play.core.server.netty.FakeKeyStore$;
import play.core.server.noCATrustManager$;
import play.server.api.SSLEngineProvider;
import play.utils.PlayIO$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.Null$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u0013\tAB)\u001a4bk2$8k\u0015'F]\u001eLg.\u001a)s_ZLG-\u001a:\u000b\u0005\r!\u0011AB:feZ,'O\u0003\u0002\u0006\r\u0005!1m\u001c:f\u0015\u00059\u0011\u0001\u00029mCf\u001c\u0001aE\u0002\u0001\u0015I\u0001\"a\u0003\t\u000e\u00031Q!!\u0004\b\u0002\t1\fgn\u001a\u0006\u0002\u001f\u0005!!.\u0019<b\u0013\t\tBB\u0001\u0004PE*,7\r\u001e\t\u0003']i\u0011\u0001\u0006\u0006\u0003+Y\t1!\u00199j\u0015\t\u0019a!\u0003\u0002\u0019)\t\t2k\u0015'F]\u001eLg.\u001a)s_ZLG-\u001a:\t\u0011i\u0001!\u0011!Q\u0001\nm\t1\"\u00199q!J|g/\u001b3feB\u0011A$H\u0007\u0002\t%\u0011a\u0004\u0002\u0002\u0014\u0003B\u0004H.[2bi&|g\u000e\u0015:pm&$WM\u001d\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\t\"\u0003CA\u0012\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e \u0001\u0004Y\u0002b\u0002\u0014\u0001\u0005\u0004%\taJ\u0001\u000bgNd7i\u001c8uKb$X#\u0001\u0015\u0011\u0005%\u0002T\"\u0001\u0016\u000b\u0005-b\u0013aA:tY*\u0011QFL\u0001\u0004]\u0016$(\"A\u0018\u0002\u000b)\fg/\u0019=\n\u0005ER#AC*T\u0019\u000e{g\u000e^3yi\"11\u0007\u0001Q\u0001\n!\n1b]:m\u0007>tG/\u001a=uA!)Q\u0007\u0001C!m\u0005y1M]3bi\u0016\u001c6\u000bT#oO&tW\rF\u00018!\tI\u0003(\u0003\u0002:U\tI1k\u0015'F]\u001eLg.\u001a\u0005\u0006w\u0001!\t\u0001P\u0001\u0011GJ,\u0017\r^3T'2\u001buN\u001c;fqR$\"\u0001K\u001f\t\u000byR\u0004\u0019A\u000e\u0002'\u0005\u0004\b\u000f\\5dCRLwN\u001c)s_ZLG-\u001a:")
public class DefaultSSLEngineProvider
implements SSLEngineProvider {
    private final SSLContext sslContext;

    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Override
    public SSLEngine createSSLEngine() {
        return this.sslContext().createSSLEngine();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SSLContext createSSLContext(ApplicationProvider applicationProvider) {
        Try<KeyManagerFactory> try_;
        Option<String> option = Option$.MODULE$.apply(System.getProperty("https.keyStore"));
        if (!(option instanceof Some)) {
            if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
            Play$.MODULE$.logger().warn((Function0<String>)((Object)new Serializable(this){

                public final String apply() {
                    return "Using generated key with self signed certificate for HTTPS. This should not be used in production.";
                }
            }));
            try_ = FakeKeyStore$.MODULE$.keyManagerFactory(applicationProvider.path());
        } else {
            Try try_2;
            Some some = (Some)option;
            String path2 = (String)some.x();
            KeyStore keyStore = KeyStore.getInstance(System.getProperty("https.keyStoreType", "JKS"));
            char[] password = System.getProperty("https.keyStorePassword", "").toCharArray();
            String algorithm2 = System.getProperty("https.keyStoreAlgorithm", KeyManagerFactory.getDefaultAlgorithm());
            File file2 = new File(path2);
            if (file2.isFile()) {
                FileInputStream in = new FileInputStream(file2);
                try {
                    keyStore.load(in, password);
                    Play$.MODULE$.logger().debug((Function0<String>)((Object)new Serializable(this, file2){
                        private final File file$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Using HTTPS keystore at ").append((Object)this.file$1.getAbsolutePath()).toString();
                        }
                        {
                            this.file$1 = file$1;
                        }
                    }));
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm2);
                    kmf.init(keyStore, password);
                    try_2 = new Success<KeyManagerFactory>(kmf);
                }
                catch (Throwable throwable) {
                    try {
                        Throwable throwable2 = throwable;
                        Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable2);
                        if (option2.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = option2.get();
                        Failure failure2 = new Failure(new Exception(new StringBuilder().append((Object)"Error loading HTTPS keystore from ").append((Object)file2.getAbsolutePath()).toString(), e));
                        try_2 = failure2;
                    }
                    finally {
                        PlayIO$.MODULE$.closeQuietly(in);
                    }
                }
            } else {
                try_2 = new Failure<KeyManagerFactory>(new Exception(new StringBuilder().append((Object)"Unable to find HTTPS keystore at \"").append((Object)file2.getAbsolutePath()).append((Object)"\"").toString()));
            }
            try_ = try_2;
        }
        Try<KeyManagerFactory> keyManagerFactory2 = try_;
        return keyManagerFactory2.map(new Serializable(this){

            /*
             * WARNING - void declaration
             */
            public final SSLContext apply(KeyManagerFactory kmf) {
                void var3_3;
                TrustManager[] tm = (TrustManager[])Option$.MODULE$.apply(System.getProperty("https.trustStore")).map(new Serializable(this){

                    public final TrustManager[] apply(String x0$1) {
                        TrustManager[] trustManagerArray;
                        String string2 = x0$1;
                        if ("noCA".equals(string2)) {
                            Play$.MODULE$.logger().warn((Function0<String>)((Object)new Serializable(this){

                                public final String apply() {
                                    return "HTTPS configured with no client side CA verification. Requires http://webid.info/ for client certificate verification.";
                                }
                            }));
                            trustManagerArray = (TrustManager[])((Object[])new TrustManager[]{noCATrustManager$.MODULE$});
                        } else {
                            Play$.MODULE$.logger().debug((Function0<String>)((Object)new Serializable(this){

                                public final String apply() {
                                    return "Using default trust store for client side CA verification";
                                }
                            }));
                            trustManagerArray = null;
                        }
                        return trustManagerArray;
                    }
                }).getOrElse(new Serializable(this){

                    public final Null$ apply() {
                        Play$.MODULE$.logger().debug((Function0<String>)((Object)new Serializable(this){

                            public final String apply() {
                                return "Using default trust store for client side CA verification";
                            }
                        }));
                        return null;
                    }
                });
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(kmf.getKeyManagers(), tm, null);
                return var3_3;
            }
        }).get();
    }

    public DefaultSSLEngineProvider(ApplicationProvider appProvider) {
        this.sslContext = this.createSSLContext(appProvider);
    }
}

