/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.netty;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import javax.net.ssl.KeyManagerFactory;
import play.api.Play$;
import play.core.server.netty.FakeKeyStore$;
import play.utils.PlayIO$;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;
import scala.util.Failure;
import scala.util.Properties$;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class FakeKeyStore$ {
    public static final FakeKeyStore$ MODULE$;
    private final String GeneratedKeyStore;
    private final String DnName;

    static {
        new FakeKeyStore$();
    }

    public String GeneratedKeyStore() {
        return this.GeneratedKeyStore;
    }

    public String DnName() {
        return this.DnName;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldGenerate(File keyStoreFile) {
        boolean bl;
        Object object = new Object();
        try {
            if (!keyStoreFile.exists()) return true;
            KeyStore store = KeyStore.getInstance("JKS");
            FileInputStream in = new FileInputStream(keyStoreFile);
            try {
                store.load(in, "".toCharArray());
                PlayIO$.MODULE$.closeQuietly(in);
                JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(store.aliases()).asScala().foreach(new Serializable(store, object){
                    private final KeyStore store$1;
                    public final Object nonLocalReturnKey1$1;

                    public final Option<BoxedUnit> apply(String alias) {
                        return Option$.MODULE$.apply(this.store$1.getCertificate(alias)).map(new Serializable(this){
                            private final /* synthetic */ anonfun.shouldGenerate.1 $outer;

                            public final void apply(Certificate c) {
                                RSAPublicKey key = (RSAPublicKey)c.getPublicKey();
                                if (key.getModulus().bitLength() < 2048) {
                                    throw new NonLocalReturnControl$mcZ$sp(this.$outer.nonLocalReturnKey1$1, true);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.store$1 = store$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                return false;
            }
            catch (Throwable throwable) {
                void var5_4;
                PlayIO$.MODULE$.closeQuietly((Closeable)var5_4);
                throw throwable;
            }
        }
        catch (NonLocalReturnControl nonLocalReturnControl22) {
            if (nonLocalReturnControl22.key() != object) throw nonLocalReturnControl22;
            bl = nonLocalReturnControl22.value$mcZ$sp();
        }
        return bl;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public Try<KeyManagerFactory> keyManagerFactory(File appPath) {
        Try try_;
        block8: {
            try {
                KeyStore keyStore = KeyStore.getInstance("JKS");
                File keyStoreFile = new File(appPath, this.GeneratedKeyStore());
                if (this.shouldGenerate(keyStoreFile)) {
                    Play$.MODULE$.logger().info((Function0<String>)((Object)new Serializable(keyStoreFile){
                        private final File keyStoreFile$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Generating HTTPS key pair in ").append((Object)this.keyStoreFile$1.getAbsolutePath()).append((Object)" - this may take some time. If nothing happens, try moving the mouse/typing on the keyboard to generate some entropy.").toString();
                        }
                        {
                            this.keyStoreFile$1 = keyStoreFile$1;
                        }
                    }));
                    KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                    keyPairGenerator.initialize(2048);
                    KeyPair keyPair = keyPairGenerator.generateKeyPair();
                    X509Certificate cert = this.createSelfSignedCertificate(keyPair);
                    keyStore.load(null, "".toCharArray());
                    keyStore.setKeyEntry("playgenerated", keyPair.getPrivate(), "".toCharArray(), (Certificate[])((Object[])new Certificate[]{cert}));
                    keyStore.setCertificateEntry("playgeneratedtrusted", cert);
                    FileOutputStream out = new FileOutputStream(keyStoreFile);
                    keyStore.store(out, "".toCharArray());
                    PlayIO$.MODULE$.closeQuietly(out);
                }
                FileInputStream in = new FileInputStream(keyStoreFile);
                try {
                    keyStore.load(in, "".toCharArray());
                    PlayIO$.MODULE$.closeQuietly(in);
                }
                catch (Throwable throwable) {
                    void var14_8;
                    PlayIO$.MODULE$.closeQuietly((Closeable)var14_8);
                    throw throwable;
                }
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(keyStore, "".toCharArray());
                try_ = new Success<KeyManagerFactory>(kmf);
                break block8;
                catch (Throwable throwable) {
                    void var12_7;
                    PlayIO$.MODULE$.closeQuietly((Closeable)var12_7);
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Failure<KeyManagerFactory> failure2;
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = option.get();
                try_ = failure2 = new Failure<KeyManagerFactory>(new Exception("Error loading fake key store", e));
            }
        }
        return try_;
    }

    public X509Certificate createSelfSignedCertificate(KeyPair keyPair) {
        X509CertInfo certInfo = new X509CertInfo();
        certInfo.set("serialNumber", new CertificateSerialNumber(new BigInteger(64, new SecureRandom())));
        certInfo.set("version", new CertificateVersion(2));
        Date validFrom = new Date();
        Date validTo2 = new Date(validFrom.getTime() + 1576800000000L);
        CertificateValidity validity = new CertificateValidity(validFrom, validTo2);
        certInfo.set("validity", validity);
        X500Name owner2 = new X500Name(this.DnName());
        boolean justName = Properties$.MODULE$.isJavaAtLeast("1.8");
        certInfo.set("subject", justName ? owner2 : new CertificateSubjectName(owner2));
        certInfo.set("issuer", justName ? owner2 : new CertificateIssuerName(owner2));
        certInfo.set("key", new CertificateX509Key(keyPair.getPublic()));
        AlgorithmId algorithm2 = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid);
        certInfo.set("algorithmID", new CertificateAlgorithmId(algorithm2));
        X509CertImpl cert = new X509CertImpl(certInfo);
        cert.sign(keyPair.getPrivate(), "SHA1withRSA");
        AlgorithmId actualAlgorithm = (AlgorithmId)cert.get("x509.algorithm");
        certInfo.set("algorithmID.algorithm", actualAlgorithm);
        X509CertImpl newCert = new X509CertImpl(certInfo);
        newCert.sign(keyPair.getPrivate(), "SHA1withRSA");
        return newCert;
    }

    private FakeKeyStore$() {
        MODULE$ = this;
        this.GeneratedKeyStore = "conf/generated.keystore";
        this.DnName = "CN=localhost, OU=Unit Testing, O=Mavericks, L=Moon Base 1, ST=Cyberspace, C=CY";
    }
}

