/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.netty;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import play.api.Logger$;
import play.api.Play$;
import play.api.libs.iteratee.Enumerator;
import play.api.libs.iteratee.Input;
import play.api.libs.iteratee.Input$EOF$;
import play.api.mvc.WebSocket;
import play.core.Execution$Implicits$;
import play.core.server.WebSocketable;
import play.core.server.netty.NettyFuture$;
import play.core.server.netty.WebSocketHandler;
import play.core.server.netty.WebSocketHandler$;
import play.core.server.netty.WebSocketHandler$$anon$1$;
import play.core.server.websocket.FrameFormatter;
import play.core.server.websocket.WebSocketHandshake$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class WebSocketHandler$class {
    public static Tuple2 newWebSocketInHandler(WebSocketHandler $this, WebSocket.FrameFormatter frameFormatter, long bufferLimit) {
        FrameFormatter nettyFrameFormatter = (FrameFormatter)frameFormatter;
        WebSocketHandler.WebSocketEnumerator enumerator = new WebSocketHandler.WebSocketEnumerator($this);
        return new Tuple2(enumerator, new SimpleChannelUpstreamHandler($this, nettyFrameFormatter, enumerator, bufferLimit){
            private Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>> continuationBuffer;
            private final /* synthetic */ WebSocketHandler $outer;
            private final FrameFormatter nettyFrameFormatter$1;
            public final WebSocketHandler.WebSocketEnumerator enumerator$1;
            private final long bufferLimit$1;

            private Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>> continuationBuffer() {
                return this.continuationBuffer;
            }

            private void continuationBuffer_$eq(Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>> x$1) {
                this.continuationBuffer = x$1;
            }

            /*
             * Enabled aggressive block sorting
             */
            public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
                Object frame;
                Object frame2;
                Object frame3;
                Object frame4;
                Tuple2<Object, Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>>> tuple2 = new Tuple2<Object, Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>>>(e.getMessage(), this.continuationBuffer());
                if (tuple2 != null) {
                    Object frame5 = tuple2._1();
                    Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>> option = tuple2._2();
                    if (frame5 instanceof ContinuationWebSocketFrame) {
                        Some some;
                        Tuple2 tuple22;
                        ContinuationWebSocketFrame continuationWebSocketFrame = (ContinuationWebSocketFrame)frame5;
                        if (option instanceof Some && (tuple22 = (Tuple2)(some = (Some)option).x()) != null) {
                            ChannelBuffer buffer2 = (ChannelBuffer)tuple22._2();
                            if ((long)(continuationWebSocketFrame.getBinaryData().readableBytes() + buffer2.readableBytes()) > this.bufferLimit$1) {
                                this.closeWebSocket(ctx, this.$outer.WebSocketMessageTooLong(), new StringBuilder().append((Object)"Fragmented message too long, configured limit is ").append(BoxesRunTime.boxToLong(this.bufferLimit$1)).toString());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    Object frame6 = tuple2._1();
                    Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>> option = tuple2._2();
                    if (frame6 instanceof ContinuationWebSocketFrame) {
                        Some some;
                        Tuple2 tuple23;
                        ContinuationWebSocketFrame continuationWebSocketFrame = (ContinuationWebSocketFrame)frame6;
                        if (option instanceof Some && (tuple23 = (Tuple2)(some = (Some)option).x()) != null) {
                            ChannelBuffer buffer3 = (ChannelBuffer)tuple23._2();
                            if (!continuationWebSocketFrame.isFinalFragment()) {
                                buffer3.writeBytes(continuationWebSocketFrame.getBinaryData());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    Object frame7 = tuple2._1();
                    Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>> option = tuple2._2();
                    if (frame7 instanceof ContinuationWebSocketFrame) {
                        Some some;
                        Tuple2 tuple24;
                        ContinuationWebSocketFrame continuationWebSocketFrame = (ContinuationWebSocketFrame)frame7;
                        if (option instanceof Some && (tuple24 = (Tuple2)(some = (Some)option).x()) != null) {
                            Function1 creator = (Function1)tuple24._1();
                            ChannelBuffer buffer4 = (ChannelBuffer)tuple24._2();
                            buffer4.writeBytes(continuationWebSocketFrame.getBinaryData());
                            this.continuationBuffer_$eq(None$.MODULE$);
                            WebSocketFrame finalFrame = (WebSocketFrame)creator.apply(buffer4);
                            this.enumerator$1.frameReceived(ctx, new Input.El<R>(this.nettyFrameFormatter$1.fromFrame().apply(finalFrame)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                }
                if (tuple2 != null) {
                    Object frame8 = tuple2._1();
                    Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>> option = tuple2._2();
                    if (frame8 instanceof TextWebSocketFrame) {
                        TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)frame8;
                        if (None$.MODULE$.equals(option) && !textWebSocketFrame.isFinalFragment() && this.nettyFrameFormatter$1.fromFrame().isDefinedAt(textWebSocketFrame)) {
                            ChannelBuffer buffer5 = ChannelBuffers.dynamicBuffer(Math.min(textWebSocketFrame.getBinaryData().readableBytes() * 2, (int)this.bufferLimit$1));
                            buffer5.writeBytes(textWebSocketFrame.getBinaryData());
                            this.continuationBuffer_$eq(new Some<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>>(new Tuple2<WebSocketHandler$$anon$1$.anonfun.messageReceived.1, ChannelBuffer>(new Serializable(this, buffer5, textWebSocketFrame){
                                private final ChannelBuffer buffer$1;
                                private final TextWebSocketFrame x23$1;

                                public final TextWebSocketFrame apply(ChannelBuffer b) {
                                    return new TextWebSocketFrame(true, this.x23$1.getRsv(), this.buffer$1);
                                }
                                {
                                    this.buffer$1 = buffer$1;
                                    this.x23$1 = x23$1;
                                }
                            }, buffer5)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                }
                if (tuple2 != null) {
                    Object frame9 = tuple2._1();
                    Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>> option = tuple2._2();
                    if (frame9 instanceof BinaryWebSocketFrame) {
                        BinaryWebSocketFrame binaryWebSocketFrame = (BinaryWebSocketFrame)frame9;
                        if (None$.MODULE$.equals(option) && !binaryWebSocketFrame.isFinalFragment() && this.nettyFrameFormatter$1.fromFrame().isDefinedAt(binaryWebSocketFrame)) {
                            ChannelBuffer buffer6 = ChannelBuffers.dynamicBuffer(Math.min(binaryWebSocketFrame.getBinaryData().readableBytes() * 2, (int)this.bufferLimit$1));
                            buffer6.writeBytes(binaryWebSocketFrame.getBinaryData());
                            this.continuationBuffer_$eq(new Some<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>>(new Tuple2<WebSocketHandler$$anon$1$.anonfun.messageReceived.2, ChannelBuffer>(new Serializable(this, buffer6, binaryWebSocketFrame){
                                private final ChannelBuffer buffer$2;
                                private final BinaryWebSocketFrame x25$1;

                                public final BinaryWebSocketFrame apply(ChannelBuffer b) {
                                    return new BinaryWebSocketFrame(true, this.x25$1.getRsv(), this.buffer$2);
                                }
                                {
                                    this.buffer$2 = buffer$2;
                                    this.x25$1 = x25$1;
                                }
                            }, buffer6)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                }
                if (tuple2 != null) {
                    Object frame10 = tuple2._1();
                    Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>> option = tuple2._2();
                    if (frame10 instanceof WebSocketFrame) {
                        WebSocketFrame webSocketFrame = (WebSocketFrame)frame10;
                        if (None$.MODULE$.equals(option) && this.nettyFrameFormatter$1.fromFrame().isDefinedAt(webSocketFrame)) {
                            this.enumerator$1.frameReceived(ctx, new Input.El<R>(this.nettyFrameFormatter$1.fromFrame().apply(webSocketFrame)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                }
                if (tuple2 != null && (frame4 = tuple2._1()) instanceof CloseWebSocketFrame) {
                    CloseWebSocketFrame closeWebSocketFrame = (CloseWebSocketFrame)frame4;
                    this.closeWebSocket(ctx, closeWebSocketFrame.getStatusCode(), "");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (tuple2 != null && (frame3 = tuple2._1()) instanceof PingWebSocketFrame) {
                    PingWebSocketFrame pingWebSocketFrame = (PingWebSocketFrame)frame3;
                    ctx.getChannel().write(new PongWebSocketFrame(pingWebSocketFrame.getBinaryData()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (tuple2 != null && (frame2 = tuple2._1()) instanceof PongWebSocketFrame) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (tuple2 != null && (frame = tuple2._1()) instanceof WebSocketFrame) {
                    this.closeWebSocket(ctx, this.$outer.WebSocketUnacceptable(), "This WebSocket does not handle frames of that type");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }

            public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
                e.getCause().printStackTrace();
                e.getChannel().close();
            }

            public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
                this.enumerator$1.frameReceived(ctx, Input$EOF$.MODULE$);
                Play$.MODULE$.logger().trace((Function0<String>)((Object)new Serializable(this){

                    public final String apply() {
                        return "disconnected socket";
                    }
                }));
            }

            private void closeWebSocket(ChannelHandlerContext ctx, int status, String reason) {
                if (!reason.isEmpty()) {
                    Logger$.MODULE$.trace((Function0<String>)((Object)new Serializable(this, reason){
                        private final String reason$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Closing WebSocket because ").append((Object)this.reason$1).toString();
                        }
                        {
                            this.reason$1 = reason$1;
                        }
                    }));
                }
                if (ctx.getChannel().isOpen()) {
                    NettyFuture$.MODULE$.ToScala(ctx.getChannel().write(new CloseWebSocketFrame(status, reason))).toScala().flatMap(new Serializable(this, ctx){
                        private final /* synthetic */ WebSocketHandler$.anon.1 $outer;
                        public final ChannelHandlerContext ctx$1;

                        public final Future<BoxedUnit> apply(Channel _) {
                            return NettyFuture$.MODULE$.ToScala(this.ctx$1.getChannel().close()).toScala().map(new Serializable(this){
                                private final /* synthetic */ WebSocketHandler$$anon$1$.anonfun.closeWebSocket.2 $outer;

                                public final void apply(Channel _) {
                                    this.$outer.play$core$server$netty$WebSocketHandler$$anon$$anonfun$$$outer().enumerator$1.frameReceived(this.$outer.ctx$1, Input$EOF$.MODULE$);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Execution$Implicits$.MODULE$.internalContext());
                        }

                        public /* synthetic */ WebSocketHandler$.anon.1 play$core$server$netty$WebSocketHandler$$anon$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.ctx$1 = ctx$1;
                        }
                    }, Execution$Implicits$.MODULE$.internalContext());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nettyFrameFormatter$1 = nettyFrameFormatter$1;
                this.enumerator$1 = enumerator$1;
                this.bufferLimit$1 = bufferLimit$1;
                this.continuationBuffer = None$.MODULE$;
            }
        });
    }

    public static Enumerator websocketHandshake(WebSocketHandler $this, ChannelHandlerContext ctx, HttpRequest req, MessageEvent e, long bufferLimit, WebSocket.FrameFormatter frameFormatter) {
        Tuple2 tuple2 = $this.newWebSocketInHandler(frameFormatter, bufferLimit);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Enumerator enumerator = tuple2._1();
            ChannelHandler handler = tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2(enumerator, handler);
            Enumerator enumerator2 = tuple23._1();
            ChannelHandler handler2 = tuple23._2();
            ChannelPipeline p = ctx.getChannel().getPipeline();
            p.replace("handler", "handler", handler2);
            WebSocketHandshake$.MODULE$.shake(ctx, req, bufferLimit);
            return enumerator2;
        }
        throw new MatchError(tuple2);
    }

    public static WebSocketable websocketable(WebSocketHandler $this, HttpRequest req) {
        return new WebSocketable($this, req){
            private final HttpRequest req$1;

            public boolean check() {
                return "WebSocket".equalsIgnoreCase(this.req$1.headers().get("Upgrade"));
            }

            public String getHeader(String header2) {
                return this.req$1.headers().get(header2);
            }
            {
                this.req$1 = req$1;
            }
        };
    }

    public static void $init$(WebSocketHandler $this) {
        $this.play$core$server$netty$WebSocketHandler$_setter_$WebSocketNormalClose_$eq(1000);
        $this.play$core$server$netty$WebSocketHandler$_setter_$WebSocketUnacceptable_$eq(1003);
        $this.play$core$server$netty$WebSocketHandler$_setter_$WebSocketMessageTooLong_$eq(1009);
        $this.play$core$server$netty$WebSocketHandler$_setter_$play$core$server$netty$WebSocketHandler$$MaxInFlight_$eq(3);
    }
}

