/*
 * Decompiled with CFR 0.152.
 */
package play.i18n;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import play.api.i18n.Lang;
import play.mvc.Http;
import scala.collection.JavaConverters;
import scala.collection.mutable.Buffer;

public class Messages {
    private static Lang getLang() {
        Lang lang = null;
        if (Http.Context.current.get() != null) {
            lang = Http.Context.current().lang();
        } else {
            Locale locale = Locale.getDefault();
            lang = new Lang(locale.getLanguage(), locale.getCountry());
        }
        return lang;
    }

    private static Buffer<Object> convertArgsToScalaBuffer(Object ... objectArray) {
        return JavaConverters.asScalaBufferConverter(Messages.wrapArgsToListIfNeeded(objectArray)).asScala();
    }

    static <T> List<T> wrapArgsToListIfNeeded(T ... TArray2) {
        List list2 = null;
        list2 = ArrayUtils.isNotEmpty(TArray2) && TArray2.length == 1 && TArray2[0] instanceof List ? (List)TArray2[0] : Arrays.asList(TArray2);
        return list2;
    }

    public static String get(Lang lang, String string2, Object ... objectArray) {
        Buffer<Object> buffer2 = Messages.convertArgsToScalaBuffer(objectArray);
        return play.api.i18n.Messages.apply(string2, buffer2, lang);
    }

    public static String get(Lang lang, List<String> list2, Object ... objectArray) {
        Buffer<String> buffer2 = JavaConverters.asScalaBufferConverter(list2).asScala();
        Buffer<Object> buffer3 = Messages.convertArgsToScalaBuffer(objectArray);
        return play.api.i18n.Messages.apply(buffer2.toSeq(), buffer3, lang);
    }

    public static String get(String string2, Object ... objectArray) {
        Buffer<Object> buffer2 = Messages.convertArgsToScalaBuffer(objectArray);
        return play.api.i18n.Messages.apply(string2, buffer2, Messages.getLang());
    }

    public static String get(List<String> list2, Object ... objectArray) {
        Buffer<String> buffer2 = JavaConverters.asScalaBufferConverter(list2).asScala();
        Buffer<Object> buffer3 = Messages.convertArgsToScalaBuffer(objectArray);
        return play.api.i18n.Messages.apply(buffer2.toSeq(), buffer3, Messages.getLang());
    }

    public static Boolean isDefined(Lang lang, String string2) {
        return play.api.i18n.Messages.isDefinedAt(string2, lang);
    }

    public static Boolean isDefined(String string2) {
        return play.api.i18n.Messages.isDefinedAt(string2, Messages.getLang());
    }
}

