/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;

public class Json {
    private static final ObjectMapper defaultObjectMapper = new ObjectMapper();
    private static volatile ObjectMapper objectMapper = null;

    private static ObjectMapper mapper() {
        if (objectMapper == null) {
            return defaultObjectMapper;
        }
        return objectMapper;
    }

    public static JsonNode toJson(Object object) {
        try {
            return Json.mapper().valueToTree(object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <A> A fromJson(JsonNode jsonNode, Class<A> clazz) {
        try {
            return Json.mapper().treeToValue(jsonNode, clazz);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ObjectNode newObject() {
        return Json.mapper().createObjectNode();
    }

    public static String stringify(JsonNode jsonNode) {
        return jsonNode.toString();
    }

    public static JsonNode parse(String string2) {
        try {
            return Json.mapper().readValue(string2, JsonNode.class);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static JsonNode parse(InputStream inputStream) {
        try {
            return Json.mapper().readValue(inputStream, JsonNode.class);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        Json.objectMapper = objectMapper;
    }
}

