/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import akka.actor.ActorRef;
import akka.actor.Props;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import play.PlayInternal;
import play.libs.F;
import play.mvc.Result;

public abstract class WebSocket<A> {
    public abstract void onReady(In<A> var1, Out<A> var2);

    public Result rejectWith() {
        return null;
    }

    public boolean isActor() {
        return false;
    }

    public Props actorProps(ActorRef actorRef) {
        return null;
    }

    public static <A> WebSocket<A> whenReady(F.Callback2<In<A>, Out<A>> callback2) {
        return new WhenReadyWebSocket<A>(callback2);
    }

    public static <A> WebSocket<A> reject(final Result result2) {
        return new WebSocket<A>(){

            @Override
            public void onReady(In<A> in, Out<A> out) {
            }

            @Override
            public Result rejectWith() {
                return result2;
            }
        };
    }

    public static <A> WebSocket<A> withActor(final F.Function<ActorRef, Props> function) {
        return new WebSocket<A>(){

            @Override
            public void onReady(In<A> in, Out<A> out) {
            }

            @Override
            public boolean isActor() {
                return true;
            }

            @Override
            public Props actorProps(ActorRef actorRef) {
                try {
                    return (Props)function.apply(actorRef);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Error error2) {
                    throw error2;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        };
    }

    static final class WhenReadyWebSocket<A>
    extends WebSocket<A> {
        private final F.Callback2<In<A>, Out<A>> callback;

        WhenReadyWebSocket(F.Callback2<In<A>, Out<A>> callback2) {
            if (callback2 == null) {
                throw new NullPointerException("WebSocket onReady callback cannot be null");
            }
            this.callback = callback2;
        }

        @Override
        public void onReady(In<A> in, Out<A> out) {
            try {
                this.callback.invoke(in, out);
            }
            catch (Throwable throwable) {
                PlayInternal.logger().error("Exception in WebSocket.onReady", throwable);
            }
        }
    }

    public static class In<A> {
        public final List<F.Callback<A>> callbacks = new CopyOnWriteArrayList<F.Callback<A>>();
        public final List<F.Callback0> closeCallbacks = new CopyOnWriteArrayList<F.Callback0>();

        public void onMessage(F.Callback<A> callback) {
            this.callbacks.add(callback);
        }

        public void onClose(F.Callback0 callback0) {
            this.closeCallbacks.add(callback0);
        }
    }

    public static interface Out<A> {
        public void write(A var1);

        public void close();
    }
}

