/*
 * Decompiled with CFR 0.152.
 */
package play.utils;

import java.io.ByteArrayOutputStream;
import java.util.BitSet;
import play.utils.InvalidUriEncodingException;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple2$mcCC$sp;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichChar;

public final class UriEncoding$ {
    public static final UriEncoding$ MODULE$;
    private final BitSet play$utils$UriEncoding$$segmentChars;

    static {
        new UriEncoding$();
    }

    public String encodePathSegment(String s2, String inputCharset) {
        byte[] in = s2.getBytes(inputCharset);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Predef$.MODULE$.byteArrayOps(in).foreach(new Serializable(out){
            private final ByteArrayOutputStream out$1;

            public final void apply(byte b) {
                boolean allowed = UriEncoding$.MODULE$.play$utils$UriEncoding$$segmentChars().get(b & 0xFF);
                if (allowed) {
                    this.out$1.write(b);
                } else {
                    this.out$1.write(37);
                    this.out$1.write(UriEncoding$.MODULE$.play$utils$UriEncoding$$upperHex(b >> 4 & 0xF));
                    this.out$1.write(UriEncoding$.MODULE$.play$utils$UriEncoding$$upperHex(b & 0xF));
                }
            }
            {
                this.out$1 = out$1;
            }
        });
        return out.toString("US-ASCII");
    }

    public String decodePathSegment(String s2, String outputCharset) {
        byte[] in = s2.getBytes("US-ASCII");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IntRef inPos = IntRef.create(0);
        while (inPos.elem < in.length) {
            int b = this.next$1(in, inPos);
            if (b == 37) {
                if (inPos.elem >= in.length) {
                    throw new InvalidUriEncodingException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot decode ", ": % at end of string"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{s2})));
                }
                int high = this.fromHex(this.next$1(in, inPos));
                if (high == -1) {
                    throw new InvalidUriEncodingException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot decode ", ": expected hex digit at position ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{s2, BoxesRunTime.boxToInteger(inPos.elem)})));
                }
                if (inPos.elem >= in.length) {
                    throw new InvalidUriEncodingException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot decode ", ": incomplete percent encoding at end of string"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{s2})));
                }
                int low = this.fromHex(this.next$1(in, inPos));
                if (low == -1) {
                    throw new InvalidUriEncodingException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot decode ", ": expected hex digit at position ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{s2, BoxesRunTime.boxToInteger(inPos.elem)})));
                }
                out.write((high << 4) + low);
                continue;
            }
            if (this.play$utils$UriEncoding$$segmentChars().get(b)) {
                out.write(b);
                continue;
            }
            throw new InvalidUriEncodingException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot decode ", ": illegal character at position ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{s2, BoxesRunTime.boxToInteger(inPos.elem)})));
        }
        return out.toString(outputCharset);
    }

    public String decodePath(String s2, String outputCharset) {
        return ((TraversableOnce)this.splitString(s2, '/').map(new Serializable(outputCharset){
            private final String outputCharset$1;

            public final String apply(String x$1) {
                return UriEncoding$.MODULE$.decodePathSegment(x$1, this.outputCharset$1);
            }
            {
                this.outputCharset$1 = outputCharset$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("/");
    }

    public BitSet play$utils$UriEncoding$$segmentChars() {
        return this.play$utils$UriEncoding$$segmentChars;
    }

    private Seq<Object> pchar() {
        Seq alphaDigit = ((TraversableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2$mcCC$sp('a', 'z'), new Tuple2$mcCC$sp('A', 'Z'), new Tuple2$mcCC$sp('0', '9')}))).withFilter(new Serializable(){

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).flatMap(new Serializable(){

            public final IndexedSeq<Object> apply(Tuple2<Object, Object> x$2) {
                Tuple2<Object, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    char min2 = tuple2._1$mcC$sp();
                    char max2 = tuple2._2$mcC$sp();
                    IndexedSeq<Object> indexedSeq = new RichChar(Predef$.MODULE$.charWrapper(min2)).to(BoxesRunTime.boxToCharacter(max2)).map(new Serializable(this){

                        public final char apply(char c) {
                            return c;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    return indexedSeq;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq unreserved = alphaDigit.$plus$plus(Seq$.MODULE$.apply(Predef$.MODULE$.wrapCharArray(new char[]{'-', '.', '_', '~'})), Seq$.MODULE$.canBuildFrom());
        Seq subDelims = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapCharArray(new char[]{'!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '='}));
        return ((TraversableLike)unreserved.$plus$plus(subDelims, Seq$.MODULE$.canBuildFrom())).$plus$plus(Seq$.MODULE$.apply(Predef$.MODULE$.wrapCharArray(new char[]{':', '@'})), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private BitSet membershipTable(Seq<Object> chars) {
        void var2_2;
        BitSet bits2 = new BitSet(256);
        chars.foreach(new Serializable(bits2){
            private final BitSet bits$1;

            public final void apply(char c) {
                this.bits$1.set(c);
            }
            {
                this.bits$1 = bits$1;
            }
        });
        return var2_2;
    }

    public int play$utils$UriEncoding$$upperHex(int x) {
        return x < 10 ? x + 48 : x - 10 + 65;
    }

    private int fromHex(int b) {
        return b >= 48 && b <= 57 ? b - 48 : (b >= 65 && b <= 90 ? 10 + b - 65 : (b >= 97 && b <= 122 ? 10 + b - 97 : -1));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> splitString(String s2, char c) {
        void var3_3;
        ListBuffer result2 = (ListBuffer)ListBuffer$.MODULE$.empty();
        this.splitLoop$1(0, s2, c, result2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final int next$1(byte[] in$1, IntRef inPos$1) {
        void var3_3;
        int b = in$1[inPos$1.elem] & 0xFF;
        ++inPos$1.elem;
        return (int)var3_3;
    }

    private final void splitLoop$1(int start2, String s$1, char c$1, ListBuffer result$1) {
        block4: {
            BoxedUnit boxedUnit;
            while (start2 < s$1.length()) {
                int end2 = s$1.indexOf(c$1, start2);
                if (end2 == -1) {
                    result$1.$plus$eq(s$1.substring(start2));
                    boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                result$1.$plus$eq(s$1.substring(start2, end2));
                start2 = end2 + 1;
            }
            if (start2 == s$1.length()) {
                result$1.$plus$eq("");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private UriEncoding$() {
        MODULE$ = this;
        this.play$utils$UriEncoding$$segmentChars = this.membershipTable(this.pchar());
    }
}

