/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

public class BufferRecycler {
    public static final int BYTE_READ_IO_BUFFER = 0;
    public static final int BYTE_WRITE_ENCODING_BUFFER = 1;
    public static final int BYTE_WRITE_CONCAT_BUFFER = 2;
    public static final int BYTE_BASE64_CODEC_BUFFER = 3;
    public static final int CHAR_TOKEN_BUFFER = 0;
    public static final int CHAR_CONCAT_BUFFER = 1;
    public static final int CHAR_TEXT_BUFFER = 2;
    public static final int CHAR_NAME_COPY_BUFFER = 3;
    private static final int[] BYTE_BUFFER_LENGTHS = new int[]{8000, 8000, 2000, 2000};
    private static final int[] CHAR_BUFFER_LENGTHS = new int[]{4000, 4000, 200, 200};
    protected final byte[][] _byteBuffers;
    protected final char[][] _charBuffers;

    public BufferRecycler() {
        this(4, 4);
    }

    protected BufferRecycler(int bbCount, int cbCount) {
        this._byteBuffers = new byte[bbCount][];
        this._charBuffers = new char[cbCount][];
    }

    public final byte[] allocByteBuffer(int ix) {
        return this.allocByteBuffer(ix, 0);
    }

    public byte[] allocByteBuffer(int ix, int minSize) {
        byte[] buffer2;
        int DEF_SIZE = this.byteBufferLength(ix);
        if (minSize < DEF_SIZE) {
            minSize = DEF_SIZE;
        }
        if ((buffer2 = this._byteBuffers[ix]) == null || buffer2.length < minSize) {
            buffer2 = this.balloc(minSize);
        } else {
            this._byteBuffers[ix] = null;
        }
        return buffer2;
    }

    public final void releaseByteBuffer(int ix, byte[] buffer2) {
        this._byteBuffers[ix] = buffer2;
    }

    public final char[] allocCharBuffer(int ix) {
        return this.allocCharBuffer(ix, 0);
    }

    public char[] allocCharBuffer(int ix, int minSize) {
        char[] buffer2;
        int DEF_SIZE = this.charBufferLength(ix);
        if (minSize < DEF_SIZE) {
            minSize = DEF_SIZE;
        }
        if ((buffer2 = this._charBuffers[ix]) == null || buffer2.length < minSize) {
            buffer2 = this.calloc(minSize);
        } else {
            this._charBuffers[ix] = null;
        }
        return buffer2;
    }

    public void releaseCharBuffer(int ix, char[] buffer2) {
        this._charBuffers[ix] = buffer2;
    }

    protected int byteBufferLength(int ix) {
        return BYTE_BUFFER_LENGTHS[ix];
    }

    protected int charBufferLength(int ix) {
        return CHAR_BUFFER_LENGTHS[ix];
    }

    protected byte[] balloc(int size2) {
        return new byte[size2];
    }

    protected char[] calloc(int size2) {
        return new char[size2];
    }
}

