/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;

public class LocalDateTimeSerializer
extends JSR310FormattedSerializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalDateTimeSerializer INSTANCE = new LocalDateTimeSerializer();

    protected LocalDateTimeSerializer() {
        this((DateTimeFormatter)null);
    }

    public LocalDateTimeSerializer(DateTimeFormatter f2) {
        super(LocalDateTime.class, f2);
    }

    private LocalDateTimeSerializer(LocalDateTimeSerializer base, Boolean useTimestamp, DateTimeFormatter f2) {
        super(base, useTimestamp, f2);
    }

    @Override
    protected JSR310FormattedSerializerBase<LocalDateTime> withFormat(Boolean useTimestamp, DateTimeFormatter f2) {
        return new LocalDateTimeSerializer(this, useTimestamp, f2);
    }

    @Override
    public void serialize(LocalDateTime value2, JsonGenerator g2, SerializerProvider provider) throws IOException {
        if (this.useTimestamp(provider)) {
            g2.writeStartArray();
            g2.writeNumber(value2.getYear());
            g2.writeNumber(value2.getMonthValue());
            g2.writeNumber(value2.getDayOfMonth());
            g2.writeNumber(value2.getHour());
            g2.writeNumber(value2.getMinute());
            if (value2.getSecond() > 0 || value2.getNano() > 0) {
                g2.writeNumber(value2.getSecond());
                if (value2.getNano() > 0) {
                    if (provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                        g2.writeNumber(value2.getNano());
                    } else {
                        g2.writeNumber(value2.get(ChronoField.MILLI_OF_SECOND));
                    }
                }
            }
            g2.writeEndArray();
        } else {
            DateTimeFormatter dtf = this._formatter;
            if (dtf == null) {
                dtf = this._defaultFormatter();
            }
            g2.writeString(value2.format(dtf));
        }
    }

    protected DateTimeFormatter _defaultFormatter() {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    }
}

