/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import com.googlecode.javaewah.benchmark.UniformDataGenerator;

public class ClusteredDataGenerator {
    UniformDataGenerator unidg;

    public ClusteredDataGenerator() {
        this.unidg = new UniformDataGenerator();
    }

    public ClusteredDataGenerator(int seed) {
        this.unidg = new UniformDataGenerator(seed);
    }

    public int[] generateClustered(int N, int Max2) {
        int[] array = new int[N];
        this.fillClustered(array, 0, N, 0, Max2);
        return array;
    }

    void fillClustered(int[] array, int offset, int length, int Min2, int Max2) {
        int range2 = Max2 - Min2;
        if (range2 == length || length <= 10) {
            this.fillUniform(array, offset, length, Min2, Max2);
            return;
        }
        int cut = length / 2 + (range2 - length - 1 > 0 ? this.unidg.rand.nextInt(range2 - length - 1) : 0);
        double p = this.unidg.rand.nextDouble();
        if (p < 0.25) {
            this.fillUniform(array, offset, length / 2, Min2, Min2 + cut);
            this.fillClustered(array, offset + length / 2, length - length / 2, Min2 + cut, Max2);
        } else if (p < 0.5) {
            this.fillClustered(array, offset, length / 2, Min2, Min2 + cut);
            this.fillUniform(array, offset + length / 2, length - length / 2, Min2 + cut, Max2);
        } else {
            this.fillClustered(array, offset, length / 2, Min2, Min2 + cut);
            this.fillClustered(array, offset + length / 2, length - length / 2, Min2 + cut, Max2);
        }
    }

    void fillUniform(int[] array, int offset, int length, int Min2, int Max2) {
        int[] v = this.unidg.generateUniform(length, Max2 - Min2);
        for (int k = 0; k < v.length; ++k) {
            array[k + offset] = Min2 + v[k];
        }
    }
}

