/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.nntp;

import java.util.HashMap;
import org.apache.commons.net.nntp.ThreadContainer;
import org.apache.commons.net.nntp.Threadable;

public class Threader {
    private ThreadContainer root;
    private HashMap<String, ThreadContainer> idTable;
    private int bogusIdCount = 0;

    public Threadable thread(Threadable[] messages2) {
        if (messages2 == null) {
            return null;
        }
        this.idTable = new HashMap();
        for (int i = 0; i < messages2.length; ++i) {
            if (messages2[i].isDummy()) continue;
            this.buildContainer(messages2[i]);
        }
        this.root = this.findRootSet();
        this.idTable.clear();
        this.idTable = null;
        this.pruneEmptyContainers(this.root);
        this.root.reverseChildren();
        this.gatherSubjects();
        if (this.root.next != null) {
            throw new RuntimeException("root node has a next:" + this.root);
        }
        ThreadContainer r = this.root.child;
        while (r != null) {
            if (r.threadable == null) {
                r.threadable = r.child.threadable.makeDummy();
            }
            r = r.next;
        }
        Threadable result2 = this.root.child == null ? null : this.root.child.threadable;
        this.root.flush();
        this.root = null;
        return result2;
    }

    private void buildContainer(Threadable threadable) {
        String id2 = threadable.messageThreadId();
        ThreadContainer container = this.idTable.get(id2);
        if (container != null) {
            if (container.threadable != null) {
                id2 = "<Bogus-id:" + this.bogusIdCount++ + ">";
                container = null;
            } else {
                container.threadable = threadable;
            }
        }
        if (container == null) {
            container = new ThreadContainer();
            container.threadable = threadable;
            this.idTable.put(id2, container);
        }
        ThreadContainer parentRef = null;
        String[] references = threadable.messageThreadReferences();
        for (int i = 0; i < references.length; ++i) {
            String refString = references[i];
            ThreadContainer ref2 = this.idTable.get(refString);
            if (ref2 == null) {
                ref2 = new ThreadContainer();
                this.idTable.put(refString, ref2);
            }
            if (parentRef != null && ref2.parent == null && parentRef != ref2 && !parentRef.findChild(ref2)) {
                ref2.parent = parentRef;
                ref2.next = parentRef.child;
                parentRef.child = ref2;
            }
            parentRef = ref2;
        }
        if (parentRef != null && (parentRef == container || container.findChild(parentRef))) {
            parentRef = null;
        }
        if (container.parent != null) {
            ThreadContainer prev = null;
            ThreadContainer rest2 = container.parent.child;
            while (rest2 != null && rest2 != container) {
                prev = rest2;
                rest2 = rest2.next;
            }
            if (rest2 == null) {
                throw new RuntimeException("Didnt find " + container + " in parent" + container.parent);
            }
            if (prev == null) {
                container.parent.child = container.next;
            } else {
                prev.next = container.next;
            }
            container.next = null;
            container.parent = null;
        }
        if (parentRef != null) {
            container.parent = parentRef;
            container.next = parentRef.child;
            parentRef.child = container;
        }
    }

    private ThreadContainer findRootSet() {
        ThreadContainer root2 = new ThreadContainer();
        for (String key : this.idTable.keySet()) {
            ThreadContainer c = this.idTable.get(key);
            if (c.parent != null) continue;
            if (c.next != null) {
                throw new RuntimeException("c.next is " + c.next.toString());
            }
            c.next = root2.child;
            root2.child = c;
        }
        return root2;
    }

    private void pruneEmptyContainers(ThreadContainer parent) {
        ThreadContainer prev = null;
        ThreadContainer container = parent.child;
        ThreadContainer next2 = container.next;
        while (container != null) {
            if (container.threadable == null && container.child == null) {
                if (prev == null) {
                    parent.child = container.next;
                } else {
                    prev.next = container.next;
                }
                container = prev;
            } else if (container.threadable == null && container.child != null && (container.parent != null || container.child.next == null)) {
                ThreadContainer kids = container.child;
                if (prev == null) {
                    parent.child = kids;
                } else {
                    prev.next = kids;
                }
                ThreadContainer tail2 = kids;
                while (tail2.next != null) {
                    tail2.parent = container.parent;
                    tail2 = tail2.next;
                }
                tail2.parent = container.parent;
                tail2.next = container.next;
                next2 = kids;
                container = prev;
            } else if (container.child != null) {
                this.pruneEmptyContainers(container);
            }
            prev = container;
            container = next2;
            next2 = container == null ? null : container.next;
        }
    }

    private void gatherSubjects() {
        int count2 = 0;
        ThreadContainer c = this.root.child;
        while (c != null) {
            ++count2;
            c = c.next;
        }
        HashMap<String, ThreadContainer> subjectTable = new HashMap<String, ThreadContainer>((int)((double)count2 * 1.2), 0.9f);
        count2 = 0;
        ThreadContainer c2 = this.root.child;
        while (c2 != null) {
            ThreadContainer old;
            String subj;
            Threadable threadable = c2.threadable;
            if (threadable == null) {
                threadable = c2.child.threadable;
            }
            if ((subj = threadable.simplifiedSubject()) != null && subj != "" && ((old = (ThreadContainer)subjectTable.get(subj)) == null || c2.threadable == null && old.threadable != null || old.threadable != null && old.threadable.subjectIsReply() && c2.threadable != null && !c2.threadable.subjectIsReply())) {
                subjectTable.put(subj, c2);
                ++count2;
            }
            c2 = c2.next;
        }
        if (count2 == 0) {
            return;
        }
        ThreadContainer prev = null;
        ThreadContainer c3 = this.root.child;
        ThreadContainer rest2 = c3.next;
        while (c3 != null) {
            ThreadContainer old;
            String subj;
            Threadable threadable = c3.threadable;
            if (threadable == null) {
                threadable = c3.child.threadable;
            }
            if ((subj = threadable.simplifiedSubject()) != null && subj != "" && (old = (ThreadContainer)subjectTable.get(subj)) != c3) {
                if (prev == null) {
                    this.root.child = c3.next;
                } else {
                    prev.next = c3.next;
                }
                c3.next = null;
                if (old.threadable == null && c3.threadable == null) {
                    ThreadContainer tail2 = old.child;
                    while (tail2 != null && tail2.next != null) {
                        tail2 = tail2.next;
                    }
                    tail2.next = c3.child;
                    tail2 = c3.child;
                    while (tail2 != null) {
                        tail2.parent = old;
                        tail2 = tail2.next;
                    }
                    c3.child = null;
                } else if (old.threadable == null || c3.threadable != null && c3.threadable.subjectIsReply() && !old.threadable.subjectIsReply()) {
                    c3.parent = old;
                    c3.next = old.child;
                    old.child = c3;
                } else {
                    ThreadContainer newc = new ThreadContainer();
                    newc.threadable = old.threadable;
                    ThreadContainer tail3 = newc.child = old.child;
                    while (tail3 != null) {
                        tail3.parent = newc;
                        tail3 = tail3.next;
                    }
                    old.threadable = null;
                    old.child = null;
                    c3.parent = old;
                    newc.parent = old;
                    old.child = c3;
                    c3.next = newc;
                }
                c3 = prev;
            }
            prev = c3;
            c3 = rest2;
            rest2 = rest2 == null ? null : rest2.next;
        }
        subjectTable.clear();
        subjectTable = null;
    }
}

