/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.tftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.net.io.FromNetASCIIOutputStream;
import org.apache.commons.net.io.ToNetASCIIInputStream;
import org.apache.commons.net.tftp.TFTP;
import org.apache.commons.net.tftp.TFTPAckPacket;
import org.apache.commons.net.tftp.TFTPDataPacket;
import org.apache.commons.net.tftp.TFTPErrorPacket;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;
import org.apache.commons.net.tftp.TFTPReadRequestPacket;
import org.apache.commons.net.tftp.TFTPWriteRequestPacket;

public class TFTPClient
extends TFTP {
    public static final int DEFAULT_MAX_TIMEOUTS = 5;
    private int __maxTimeouts = 5;

    public void setMaxTimeouts(int numTimeouts) {
        this.__maxTimeouts = numTimeouts < 1 ? 1 : numTimeouts;
    }

    public int getMaxTimeouts() {
        return this.__maxTimeouts;
    }

    public int receiveFile(String filename2, int mode, OutputStream output2, InetAddress host, int port) throws IOException {
        TFTPPacket received = null;
        TFTPAckPacket ack = new TFTPAckPacket(host, port, 0);
        this.beginBufferedOps();
        int bytesRead = 0;
        int hostPort = 0;
        int lastBlock = 0;
        int dataLength = 0;
        int block = 1;
        if (mode == 0) {
            output2 = new FromNetASCIIOutputStream(output2);
        }
        TFTPPacket sent = new TFTPReadRequestPacket(host, port, filename2, mode);
        block10: do {
            block17: {
                TFTPErrorPacket error2;
                this.bufferedSend(sent);
                block11: while (true) {
                    int timeouts = 0;
                    while (timeouts < this.__maxTimeouts) {
                        try {
                            received = this.bufferedReceive();
                            break;
                        }
                        catch (SocketException e) {
                            if (++timeouts < this.__maxTimeouts) continue;
                            this.endBufferedOps();
                            throw new IOException("Connection timed out.");
                        }
                        catch (InterruptedIOException e) {
                            if (++timeouts < this.__maxTimeouts) continue;
                            this.endBufferedOps();
                            throw new IOException("Connection timed out.");
                        }
                        catch (TFTPPacketException e) {
                            this.endBufferedOps();
                            throw new IOException("Bad packet: " + e.getMessage());
                        }
                    }
                    if (lastBlock == 0) {
                        hostPort = received.getPort();
                        ack.setPort(hostPort);
                        if (!host.equals(received.getAddress())) {
                            host = received.getAddress();
                            ack.setAddress(host);
                            sent.setAddress(host);
                        }
                    }
                    if (!host.equals(received.getAddress()) || received.getPort() != hostPort) break;
                    switch (received.getType()) {
                        case 5: {
                            error2 = (TFTPErrorPacket)received;
                            this.endBufferedOps();
                            throw new IOException("Error code " + error2.getError() + " received: " + error2.getMessage());
                        }
                        case 3: {
                            TFTPDataPacket data = (TFTPDataPacket)received;
                            dataLength = data.getDataLength();
                            lastBlock = data.getBlockNumber();
                            if (lastBlock == block) {
                                try {
                                    output2.write(data.getData(), data.getDataOffset(), dataLength);
                                }
                                catch (IOException e) {
                                    error2 = new TFTPErrorPacket(host, hostPort, 3, "File write failed.");
                                    this.bufferedSend(error2);
                                    this.endBufferedOps();
                                    throw e;
                                }
                                if (++block <= 65535) break block17;
                                block = 0;
                                break block17;
                            }
                            this.discardPackets();
                            if (lastBlock != (block == 0 ? 65535 : block - 1)) continue block11;
                            continue block10;
                        }
                        default: {
                            this.endBufferedOps();
                            throw new IOException("Received unexpected packet type.");
                        }
                    }
                    break;
                }
                error2 = new TFTPErrorPacket(received.getAddress(), received.getPort(), 5, "Unexpected host or port.");
                this.bufferedSend(error2);
                continue;
            }
            ack.setBlockNumber(lastBlock);
            sent = ack;
            bytesRead += dataLength;
        } while (dataLength == 512);
        this.bufferedSend(sent);
        this.endBufferedOps();
        return bytesRead;
    }

    public int receiveFile(String filename2, int mode, OutputStream output2, String hostname, int port) throws UnknownHostException, IOException {
        return this.receiveFile(filename2, mode, output2, InetAddress.getByName(hostname), port);
    }

    public int receiveFile(String filename2, int mode, OutputStream output2, InetAddress host) throws IOException {
        return this.receiveFile(filename2, mode, output2, host, 69);
    }

    public int receiveFile(String filename2, int mode, OutputStream output2, String hostname) throws UnknownHostException, IOException {
        return this.receiveFile(filename2, mode, output2, InetAddress.getByName(hostname), 69);
    }

    public void sendFile(String filename2, int mode, InputStream input2, InetAddress host, int port) throws IOException {
        TFTPPacket received = null;
        TFTPDataPacket data = new TFTPDataPacket(host, port, 0, this._sendBuffer, 4, 0);
        boolean justStarted = true;
        this.beginBufferedOps();
        int totalThisPacket = 0;
        int bytesRead = 0;
        int hostPort = 0;
        int lastBlock = 0;
        int dataLength = 0;
        int block = 0;
        boolean lastAckWait = false;
        if (mode == 0) {
            input2 = new ToNetASCIIInputStream(input2);
        }
        TFTPPacket sent = new TFTPWriteRequestPacket(host, port, filename2, mode);
        block8: do {
            block19: {
                TFTPErrorPacket error2;
                this.bufferedSend(sent);
                block9: while (true) {
                    int timeouts = 0;
                    while (timeouts < this.__maxTimeouts) {
                        try {
                            received = this.bufferedReceive();
                            break;
                        }
                        catch (SocketException e) {
                            if (++timeouts < this.__maxTimeouts) continue;
                            this.endBufferedOps();
                            throw new IOException("Connection timed out.");
                        }
                        catch (InterruptedIOException e) {
                            if (++timeouts < this.__maxTimeouts) continue;
                            this.endBufferedOps();
                            throw new IOException("Connection timed out.");
                        }
                        catch (TFTPPacketException e) {
                            this.endBufferedOps();
                            throw new IOException("Bad packet: " + e.getMessage());
                        }
                    }
                    if (justStarted) {
                        justStarted = false;
                        hostPort = received.getPort();
                        data.setPort(hostPort);
                        if (!host.equals(received.getAddress())) {
                            host = received.getAddress();
                            data.setAddress(host);
                            sent.setAddress(host);
                        }
                    }
                    if (!host.equals(received.getAddress()) || received.getPort() != hostPort) break;
                    switch (received.getType()) {
                        case 5: {
                            error2 = (TFTPErrorPacket)received;
                            this.endBufferedOps();
                            throw new IOException("Error code " + error2.getError() + " received: " + error2.getMessage());
                        }
                        case 4: {
                            TFTPAckPacket ack = (TFTPAckPacket)received;
                            lastBlock = ack.getBlockNumber();
                            if (lastBlock == block) {
                                if (++block > 65535) {
                                    block = 0;
                                }
                                if (lastAckWait) {
                                    break block8;
                                }
                                break block19;
                            }
                            this.discardPackets();
                            if (lastBlock != (block == 0 ? 65535 : block - 1)) continue block9;
                            continue block8;
                        }
                        default: {
                            this.endBufferedOps();
                            throw new IOException("Received unexpected packet type.");
                        }
                    }
                    break;
                }
                error2 = new TFTPErrorPacket(received.getAddress(), received.getPort(), 5, "Unexpected host or port.");
                this.bufferedSend(error2);
                continue;
            }
            dataLength = 512;
            int offset = 4;
            totalThisPacket = 0;
            while (dataLength > 0 && (bytesRead = input2.read(this._sendBuffer, offset, dataLength)) > 0) {
                offset += bytesRead;
                dataLength -= bytesRead;
                totalThisPacket += bytesRead;
            }
            if (totalThisPacket < 512) {
                lastAckWait = true;
            }
            data.setBlockNumber(block);
            data.setData(this._sendBuffer, 4, totalThisPacket);
            sent = data;
        } while (totalThisPacket > 0 || lastAckWait);
        this.endBufferedOps();
    }

    public void sendFile(String filename2, int mode, InputStream input2, String hostname, int port) throws UnknownHostException, IOException {
        this.sendFile(filename2, mode, input2, InetAddress.getByName(hostname), port);
    }

    public void sendFile(String filename2, int mode, InputStream input2, InetAddress host) throws IOException {
        this.sendFile(filename2, mode, input2, host, 69);
    }

    public void sendFile(String filename2, int mode, InputStream input2, String hostname) throws UnknownHostException, IOException {
        this.sendFile(filename2, mode, input2, InetAddress.getByName(hostname), 69);
    }
}

