/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UriPatternMatcher {
    private final Map map = new HashMap();

    public synchronized void register(String pattern2, Object obj2) {
        if (pattern2 == null) {
            throw new IllegalArgumentException("URI request pattern may not be null");
        }
        this.map.put(pattern2, obj2);
    }

    public synchronized void unregister(String pattern2) {
        if (pattern2 == null) {
            return;
        }
        this.map.remove(pattern2);
    }

    public synchronized void setHandlers(Map map23) {
        if (map23 == null) {
            throw new IllegalArgumentException("Map of handlers may not be null");
        }
        this.map.clear();
        this.map.putAll(map23);
    }

    public synchronized void setObjects(Map map23) {
        if (map23 == null) {
            throw new IllegalArgumentException("Map of handlers may not be null");
        }
        this.map.clear();
        this.map.putAll(map23);
    }

    public synchronized Object lookup(String requestURI) {
        Object obj2;
        if (requestURI == null) {
            throw new IllegalArgumentException("Request URI may not be null");
        }
        int index2 = requestURI.indexOf("?");
        if (index2 != -1) {
            requestURI = requestURI.substring(0, index2);
        }
        if ((obj2 = this.map.get(requestURI)) == null) {
            String bestMatch = null;
            Iterator it = this.map.keySet().iterator();
            while (it.hasNext()) {
                String pattern2 = (String)it.next();
                if (!this.matchUriRequestPattern(pattern2, requestURI) || bestMatch != null && bestMatch.length() >= pattern2.length() && (bestMatch.length() != pattern2.length() || !pattern2.endsWith("*"))) continue;
                obj2 = this.map.get(pattern2);
                bestMatch = pattern2;
            }
        }
        return obj2;
    }

    protected boolean matchUriRequestPattern(String pattern2, String requestUri) {
        if (pattern2.equals("*")) {
            return true;
        }
        return pattern2.endsWith("*") && requestUri.startsWith(pattern2.substring(0, pattern2.length() - 1)) || pattern2.startsWith("*") && requestUri.endsWith(pattern2.substring(1, pattern2.length()));
    }
}

