/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.blame.BlameGenerator;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.io.EolCanonicalizingInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlameCommand
extends GitCommand<BlameResult> {
    private String path;
    private DiffAlgorithm diffAlgorithm;
    private RawTextComparator textComparator;
    private ObjectId startCommit;
    private Collection<ObjectId> reverseEndCommits;
    private Boolean followFileRenames;

    public BlameCommand(Repository repo) {
        super(repo);
    }

    public BlameCommand setFilePath(String filePath) {
        this.path = filePath;
        return this;
    }

    public BlameCommand setDiffAlgorithm(DiffAlgorithm diffAlgorithm) {
        this.diffAlgorithm = diffAlgorithm;
        return this;
    }

    public BlameCommand setTextComparator(RawTextComparator textComparator) {
        this.textComparator = textComparator;
        return this;
    }

    public BlameCommand setStartCommit(AnyObjectId commit2) {
        this.startCommit = commit2.toObjectId();
        return this;
    }

    public BlameCommand setFollowFileRenames(boolean follow) {
        this.followFileRenames = follow;
        return this;
    }

    public BlameCommand reverse(AnyObjectId start, AnyObjectId end2) throws IOException {
        return this.reverse(start, Collections.singleton(end2.toObjectId()));
    }

    public BlameCommand reverse(AnyObjectId start, Collection<ObjectId> end2) throws IOException {
        this.startCommit = start.toObjectId();
        this.reverseEndCommits = new ArrayList<ObjectId>(end2);
        return this;
    }

    @Override
    public BlameResult call() throws GitAPIException {
        this.checkCallable();
        BlameGenerator gen = new BlameGenerator(this.repo, this.path);
        try {
            Object dc;
            if (this.diffAlgorithm != null) {
                gen.setDiffAlgorithm(this.diffAlgorithm);
            }
            if (this.textComparator != null) {
                gen.setTextComparator(this.textComparator);
            }
            if (this.followFileRenames != null) {
                gen.setFollowFileRenames(this.followFileRenames);
            }
            if (this.reverseEndCommits != null) {
                gen.reverse((AnyObjectId)this.startCommit, this.reverseEndCommits);
            } else if (this.startCommit != null) {
                gen.push(null, this.startCommit);
            } else {
                gen.push(null, this.repo.resolve("HEAD"));
                if (!this.repo.isBare()) {
                    dc = this.repo.readDirCache();
                    int entry2 = ((DirCache)dc).findEntry(this.path);
                    if (0 <= entry2) {
                        gen.push(null, ((DirCache)dc).getEntry(entry2).getObjectId());
                    }
                    File inTree = new File(this.repo.getWorkTree(), this.path);
                    if (this.repo.getFS().isFile(inTree)) {
                        RawText rawText = this.getRawText(inTree);
                        gen.push(null, rawText);
                    }
                }
            }
            dc = gen.computeBlameResult();
            return dc;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        finally {
            gen.release();
        }
    }

    private RawText getRawText(File inTree) throws IOException, FileNotFoundException {
        RawText rawText;
        WorkingTreeOptions workingTreeOptions = this.getRepository().getConfig().get(WorkingTreeOptions.KEY);
        CoreConfig.AutoCRLF autoCRLF = workingTreeOptions.getAutoCRLF();
        switch (autoCRLF) {
            case FALSE: 
            case INPUT: {
                rawText = new RawText(inTree);
                break;
            }
            case TRUE: {
                EolCanonicalizingInputStream in = new EolCanonicalizingInputStream(new FileInputStream(inTree), true);
                rawText = new RawText(BlameCommand.toByteArray(in, (int)inTree.length()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown autocrlf option " + (Object)((Object)autoCRLF));
            }
        }
        return rawText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toByteArray(InputStream source, int upperSizeLimit) throws IOException {
        byte[] buffer2 = new byte[upperSizeLimit];
        try {
            int read2 = IO.readFully(source, buffer2, 0);
            if (read2 == upperSizeLimit) {
                byte[] byArray = buffer2;
                return byArray;
            }
            byte[] copy2 = new byte[read2];
            System.arraycopy(buffer2, 0, copy2, 0, read2);
            byte[] byArray = copy2;
            return byArray;
        }
        finally {
            source.close();
        }
    }
}

