/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanCommand
extends GitCommand<Set<String>> {
    private Set<String> paths = Collections.emptySet();
    private boolean dryRun;
    private boolean directories;
    private boolean ignore = true;

    protected CleanCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Set<String> call() throws NoWorkTreeException, GitAPIException {
        TreeSet<String> files2 = new TreeSet<String>();
        try {
            StatusCommand command = new StatusCommand(this.repo);
            Status status = command.call();
            TreeSet<String> untrackedAndIgnoredFiles = new TreeSet<String>(status.getUntracked());
            TreeSet<String> untrackedAndIgnoredDirs = new TreeSet<String>(status.getUntrackedFolders());
            FS fs = this.getRepository().getFS();
            for (String p : status.getIgnoredNotInIndex()) {
                File f2 = new File(this.repo.getWorkTree(), p);
                if (fs.isFile(f2) || fs.isSymLink(f2)) {
                    untrackedAndIgnoredFiles.add(p);
                    continue;
                }
                if (!fs.isDirectory(f2)) continue;
                untrackedAndIgnoredDirs.add(p);
            }
            Set<String> filtered2 = this.filterFolders(untrackedAndIgnoredFiles, untrackedAndIgnoredDirs);
            Set<String> notIgnoredFiles = this.filterIgnorePaths(filtered2, status.getIgnoredNotInIndex(), true);
            Set<String> notIgnoredDirs = this.filterIgnorePaths(untrackedAndIgnoredDirs, status.getIgnoredNotInIndex(), false);
            for (String file : notIgnoredFiles) {
                if (!this.paths.isEmpty() && !this.paths.contains(file)) continue;
                if (!this.dryRun) {
                    FileUtils.delete(new File(this.repo.getWorkTree(), file));
                }
                files2.add(file);
            }
            if (this.directories) {
                for (String dir : notIgnoredDirs) {
                    if (!this.paths.isEmpty() && !this.paths.contains(dir)) continue;
                    if (!this.dryRun) {
                        FileUtils.delete(new File(this.repo.getWorkTree(), dir), 1);
                    }
                    files2.add(dir + "/");
                }
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        return files2;
    }

    private Set<String> filterIgnorePaths(Set<String> inputPaths, Set<String> ignoredNotInIndex, boolean exact2) {
        if (this.ignore) {
            TreeSet<String> filtered2 = new TreeSet<String>(inputPaths);
            block0: for (String path2 : inputPaths) {
                for (String ignored : ignoredNotInIndex) {
                    if ((!exact2 || !path2.equals(ignored)) && (exact2 || !path2.startsWith(ignored))) continue;
                    filtered2.remove(path2);
                    continue block0;
                }
            }
            return filtered2;
        }
        return inputPaths;
    }

    private Set<String> filterFolders(Set<String> untracked, Set<String> untrackedFolders) {
        TreeSet<String> filtered2 = new TreeSet<String>(untracked);
        block0: for (String file : untracked) {
            for (String folder : untrackedFolders) {
                if (!file.startsWith(folder)) continue;
                filtered2.remove(file);
                continue block0;
            }
        }
        return filtered2;
    }

    public CleanCommand setPaths(Set<String> paths) {
        this.paths = paths;
        return this;
    }

    public CleanCommand setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public CleanCommand setCleanDirectories(boolean dirs2) {
        this.directories = dirs2;
        return this;
    }

    public CleanCommand setIgnore(boolean ignore2) {
        this.ignore = ignore2;
        return this;
    }
}

