/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleStatus;
import org.eclipse.jgit.submodule.SubmoduleStatusType;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmoduleStatusCommand
extends GitCommand<Map<String, SubmoduleStatus>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleStatusCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleStatusCommand addPath(String path2) {
        this.paths.add(path2);
        return this;
    }

    @Override
    public Map<String, SubmoduleStatus> call() throws GitAPIException {
        this.checkCallable();
        try {
            SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            HashMap<String, SubmoduleStatus> statuses = new HashMap<String, SubmoduleStatus>();
            while (generator.next()) {
                SubmoduleStatus status = this.getStatus(generator);
                statuses.put(status.getPath(), status);
            }
            return statuses;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubmoduleStatus getStatus(SubmoduleWalk generator) throws IOException, ConfigInvalidException {
        ObjectId headId;
        ObjectId id2 = generator.getObjectId();
        String path2 = generator.getPath();
        if (generator.getModulesPath() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.MISSING, path2, id2);
        }
        if (generator.getConfigUrl() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path2, id2);
        }
        Repository subRepo = generator.getRepository();
        if (subRepo == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path2, id2);
        }
        try {
            headId = subRepo.resolve("HEAD");
        }
        finally {
            subRepo.close();
        }
        if (headId == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path2, id2, headId);
        }
        if (!headId.equals(id2)) {
            return new SubmoduleStatus(SubmoduleStatusType.REV_CHECKED_OUT, path2, id2, headId);
        }
        return new SubmoduleStatus(SubmoduleStatusType.INITIALIZED, path2, id2, headId);
    }
}

