/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame;

import java.io.IOException;
import org.eclipse.jgit.blame.Region;
import org.eclipse.jgit.blame.ReverseWalk;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;

class Candidate {
    Candidate queueNext;
    RevCommit sourceCommit;
    PathFilter sourcePath;
    ObjectId sourceBlob;
    RawText sourceText;
    Region regionList;
    int renameScore;

    Candidate(RevCommit commit2, PathFilter path2) {
        this.sourceCommit = commit2;
        this.sourcePath = path2;
    }

    void beginResult(RevWalk rw) throws MissingObjectException, IOException {
        rw.parseBody(this.sourceCommit);
    }

    int getParentCount() {
        return this.sourceCommit.getParentCount();
    }

    RevCommit getParent(int idx) {
        return this.sourceCommit.getParent(idx);
    }

    Candidate getNextCandidate(int idx) {
        return null;
    }

    boolean has(RevFlag flag) {
        return this.sourceCommit.has(flag);
    }

    void add(RevFlag flag) {
        this.sourceCommit.add(flag);
    }

    void remove(RevFlag flag) {
        this.sourceCommit.remove(flag);
    }

    int getTime() {
        return this.sourceCommit.getCommitTime();
    }

    PersonIdent getAuthor() {
        return this.sourceCommit.getAuthorIdent();
    }

    Candidate create(RevCommit commit2, PathFilter path2) {
        return new Candidate(commit2, path2);
    }

    Candidate copy(RevCommit commit2) {
        Candidate r = this.create(commit2, this.sourcePath);
        r.sourceBlob = this.sourceBlob;
        r.sourceText = this.sourceText;
        r.regionList = this.regionList;
        r.renameScore = this.renameScore;
        return r;
    }

    void loadText(ObjectReader reader) throws IOException {
        ObjectLoader ldr = reader.open(this.sourceBlob, 3);
        this.sourceText = new RawText(ldr.getCachedBytes(Integer.MAX_VALUE));
    }

    void takeBlame(EditList editList, Candidate child) {
        Candidate.blame(editList, this, child);
    }

    private static void blame(EditList editList, Candidate a, Candidate b) {
        int d;
        Region r = b.clearRegionList();
        Region aTail = null;
        Region bTail = null;
        int eIdx = 0;
        while (eIdx < editList.size()) {
            if (r == null) {
                return;
            }
            Edit e = (Edit)editList.get(eIdx);
            if (e.getEndB() <= r.sourceStart) {
                ++eIdx;
                continue;
            }
            if (r.sourceStart < e.getBeginB()) {
                d = e.getBeginB() - r.sourceStart;
                if (r.length <= d) {
                    Region next2 = r.next;
                    r.sourceStart = e.getBeginA() - d;
                    aTail = Candidate.add(aTail, a, r);
                    r = next2;
                    continue;
                }
                aTail = Candidate.add(aTail, a, r.splitFirst(e.getBeginA() - d, d));
                r.slideAndShrink(d);
            }
            if (e.getLengthB() == 0) {
                ++eIdx;
                continue;
            }
            int rEnd = r.sourceStart + r.length;
            if (rEnd <= e.getEndB()) {
                Region next3 = r.next;
                bTail = Candidate.add(bTail, b, r);
                r = next3;
                if (rEnd != e.getEndB()) continue;
                ++eIdx;
                continue;
            }
            int len = e.getEndB() - r.sourceStart;
            bTail = Candidate.add(bTail, b, r.splitFirst(r.sourceStart, len));
            r.slideAndShrink(len);
            ++eIdx;
        }
        if (r == null) {
            return;
        }
        Edit e = (Edit)editList.get(editList.size() - 1);
        int endB = e.getEndB();
        d = endB - e.getEndA();
        if (aTail == null) {
            a.regionList = r;
        } else {
            aTail.next = r;
        }
        do {
            if (endB > r.sourceStart) continue;
            r.sourceStart -= d;
        } while ((r = r.next) != null);
    }

    private static Region add(Region aTail, Candidate a, Region n) {
        if (aTail == null) {
            a.regionList = n;
            n.next = null;
            return n;
        }
        if (aTail.resultStart + aTail.length == n.resultStart && aTail.sourceStart + aTail.length == n.sourceStart) {
            aTail.length += n.length;
            return aTail;
        }
        aTail.next = n;
        n.next = null;
        return n;
    }

    private Region clearRegionList() {
        Region r = this.regionList;
        this.regionList = null;
        return r;
    }

    boolean canMergeRegions(Candidate other) {
        return this.sourceCommit == other.sourceCommit && this.sourcePath.getPath().equals(other.sourcePath.getPath());
    }

    void mergeRegions(Candidate other) {
        Region n;
        Region a = this.clearRegionList();
        Region b = other.clearRegionList();
        Region t = null;
        while (a != null && b != null) {
            if (a.resultStart < b.resultStart) {
                n = a.next;
                t = Candidate.add(t, this, a);
                a = n;
                continue;
            }
            n = b.next;
            t = Candidate.add(t, this, b);
            b = n;
        }
        if (a != null) {
            n = a.next;
            t = Candidate.add(t, this, a);
            t.next = n;
        } else {
            n = b.next;
            t = Candidate.add(t, this, b);
            t.next = n;
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Candidate[");
        r.append(this.sourcePath.getPath());
        if (this.sourceCommit != null) {
            r.append(" @ ").append(this.sourceCommit.abbreviate(6).name());
        }
        if (this.regionList != null) {
            r.append(" regions:").append(this.regionList);
        }
        r.append("]");
        return r.toString();
    }

    static final class BlobCandidate
    extends Candidate {
        Candidate parent;
        String description;

        BlobCandidate(String name2, PathFilter path2) {
            super(null, path2);
            this.description = name2;
        }

        void beginResult(RevWalk rw) {
        }

        int getParentCount() {
            return this.parent != null ? 1 : 0;
        }

        RevCommit getParent(int idx) {
            return null;
        }

        Candidate getNextCandidate(int idx) {
            return this.parent;
        }

        boolean has(RevFlag flag) {
            return true;
        }

        void add(RevFlag flag) {
        }

        void remove(RevFlag flag) {
        }

        int getTime() {
            return Integer.MAX_VALUE;
        }

        PersonIdent getAuthor() {
            return new PersonIdent(this.description, "");
        }
    }

    static final class ReverseCandidate
    extends Candidate {
        ReverseCandidate(ReverseWalk.ReverseCommit commit2, PathFilter path2) {
            super(commit2, path2);
        }

        int getParentCount() {
            return ((ReverseWalk.ReverseCommit)this.sourceCommit).getChildCount();
        }

        RevCommit getParent(int idx) {
            return ((ReverseWalk.ReverseCommit)this.sourceCommit).getChild(idx);
        }

        int getTime() {
            return -this.sourceCommit.getCommitTime();
        }

        Candidate create(RevCommit commit2, PathFilter path2) {
            return new ReverseCandidate((ReverseWalk.ReverseCommit)commit2, path2);
        }

        public String toString() {
            return "Reverse" + super.toString();
        }
    }
}

