/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HashedSequence;
import org.eclipse.jgit.diff.HashedSequenceComparator;
import org.eclipse.jgit.diff.HistogramDiffIndex;
import org.eclipse.jgit.diff.LowLevelDiffAlgorithm;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.Subsequence;
import org.eclipse.jgit.diff.SubsequenceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistogramDiff
extends LowLevelDiffAlgorithm {
    private DiffAlgorithm fallback = MyersDiff.INSTANCE;
    private int maxChainLength = 64;

    public void setFallbackAlgorithm(DiffAlgorithm alg) {
        this.fallback = alg;
    }

    public void setMaxChainLength(int maxLen) {
        this.maxChainLength = maxLen;
    }

    @Override
    public <S extends Sequence> void diffNonCommon(EditList edits, HashedSequenceComparator<S> cmp, HashedSequence<S> a, HashedSequence<S> b, Edit region) {
        new State<S>(edits, cmp, a, b).diffRegion(region);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class State<S extends Sequence> {
        private final HashedSequenceComparator<S> cmp;
        private final HashedSequence<S> a;
        private final HashedSequence<S> b;
        private final List<Edit> queue = new ArrayList<Edit>();
        final EditList edits;

        State(EditList edits, HashedSequenceComparator<S> cmp, HashedSequence<S> a, HashedSequence<S> b) {
            this.cmp = cmp;
            this.a = a;
            this.b = b;
            this.edits = edits;
        }

        void diffRegion(Edit r) {
            this.diffReplace(r);
            while (!this.queue.isEmpty()) {
                this.diff(this.queue.remove(this.queue.size() - 1));
            }
        }

        private void diffReplace(Edit r) {
            Edit lcs = new HistogramDiffIndex<S>(HistogramDiff.this.maxChainLength, this.cmp, this.a, this.b, r).findLongestCommonSequence();
            if (lcs != null) {
                if (lcs.isEmpty()) {
                    this.edits.add(r);
                } else {
                    this.queue.add(r.after(lcs));
                    this.queue.add(r.before(lcs));
                }
            } else if (HistogramDiff.this.fallback instanceof LowLevelDiffAlgorithm) {
                LowLevelDiffAlgorithm fb = (LowLevelDiffAlgorithm)HistogramDiff.this.fallback;
                fb.diffNonCommon(this.edits, this.cmp, this.a, this.b, r);
            } else if (HistogramDiff.this.fallback != null) {
                SubsequenceComparator<HashedSequence<S>> cs = this.subcmp();
                Subsequence<HashedSequence<S>> as2 = Subsequence.a(this.a, r);
                Subsequence<HashedSequence<S>> bs = Subsequence.b(this.b, r);
                EditList res = HistogramDiff.this.fallback.diffNonCommon(cs, as2, bs);
                this.edits.addAll(Subsequence.toBase(res, as2, bs));
            } else {
                this.edits.add(r);
            }
        }

        private void diff(Edit r) {
            switch (r.getType()) {
                case INSERT: 
                case DELETE: {
                    this.edits.add(r);
                    break;
                }
                case REPLACE: {
                    if (r.getLengthA() == 1 && r.getLengthB() == 1) {
                        this.edits.add(r);
                        break;
                    }
                    this.diffReplace(r);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private SubsequenceComparator<HashedSequence<S>> subcmp() {
            return new SubsequenceComparator<HashedSequence<S>>(this.cmp);
        }
    }
}

