/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.util.Arrays;

final class BitSet {
    private long[] words;

    BitSet(int initialCapacity) {
        this.words = new long[BitSet.block(initialCapacity) + 1];
    }

    final void clear() {
        Arrays.fill(this.words, 0L);
    }

    final void set(int position2) {
        int block = BitSet.block(position2);
        if (block >= this.words.length) {
            long[] buf = new long[2 * BitSet.block(position2)];
            System.arraycopy(this.words, 0, buf, 0, this.words.length);
            this.words = buf;
        }
        int n = block;
        this.words[n] = this.words[n] | BitSet.mask(position2);
    }

    final void clear(int position2) {
        int block = BitSet.block(position2);
        if (block < this.words.length) {
            int n = block;
            this.words[n] = this.words[n] & (BitSet.mask(position2) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    final boolean get(int position2) {
        int block = BitSet.block(position2);
        return block < this.words.length && (this.words[block] & BitSet.mask(position2)) != 0L;
    }

    final EWAHCompressedBitmap toEWAHCompressedBitmap() {
        EWAHCompressedBitmap compressed = new EWAHCompressedBitmap(this.words.length);
        int runningEmptyWords = 0;
        long lastNonEmptyWord = 0L;
        for (long word : this.words) {
            if (word == 0L) {
                ++runningEmptyWords;
                continue;
            }
            if (lastNonEmptyWord != 0L) {
                compressed.add(lastNonEmptyWord);
            }
            if (runningEmptyWords > 0) {
                compressed.addStreamOfEmptyWords(false, runningEmptyWords);
                runningEmptyWords = 0;
            }
            lastNonEmptyWord = word;
        }
        int bitsThatMatter = 64 - Long.numberOfLeadingZeros(lastNonEmptyWord);
        if (bitsThatMatter > 0) {
            compressed.add(lastNonEmptyWord, bitsThatMatter);
        }
        return compressed;
    }

    private static final int block(int position2) {
        return position2 >> 6;
    }

    private static final long mask(int position2) {
        return 1L << position2;
    }
}

