/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackInputStream;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;

class LargePackedWholeObject
extends ObjectLoader {
    private final int type;
    private final long size;
    private final long objectOffset;
    private final int headerLength;
    private final PackFile pack;
    private final FileObjectDatabase db;

    LargePackedWholeObject(int type, long size2, long objectOffset, int headerLength2, PackFile pack, FileObjectDatabase db) {
        this.type = type;
        this.size = size2;
        this.objectOffset = objectOffset;
        this.headerLength = headerLength2;
        this.pack = pack;
        this.db = db;
    }

    public int getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isLarge() {
        return true;
    }

    public byte[] getCachedBytes() throws LargeObjectException {
        try {
            throw new LargeObjectException(this.getObjectId());
        }
        catch (IOException cannotObtainId) {
            LargeObjectException err2 = new LargeObjectException();
            err2.initCause(cannotObtainId);
            throw err2;
        }
    }

    public ObjectStream openStream() throws MissingObjectException, IOException {
        InputStream in;
        WindowCursor wc = new WindowCursor(this.db);
        try {
            in = new PackInputStream(this.pack, this.objectOffset + (long)this.headerLength, wc);
        }
        catch (IOException packGone) {
            return wc.open(this.getObjectId(), this.type).openStream();
        }
        in = new BufferedInputStream(new InflaterInputStream(in, wc.inflater(), 8192), 8192);
        return new ObjectStream.Filter(this.type, this.size, in);
    }

    private ObjectId getObjectId() throws IOException {
        return this.pack.findObjectForOffset(this.objectOffset);
    }
}

