/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.RawParseUtils;

public class BlobBasedConfig
extends Config {
    public BlobBasedConfig(Config base, byte[] blob) throws ConfigInvalidException {
        super(base);
        this.fromText(RawParseUtils.decode(blob));
    }

    public BlobBasedConfig(Config base, Repository db, AnyObjectId objectId) throws IOException, ConfigInvalidException {
        this(base, BlobBasedConfig.read(db, objectId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] read(Repository db, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectReader or = db.newObjectReader();
        try {
            byte[] byArray = BlobBasedConfig.read(or, blobId);
            Object var5_4 = null;
            or.release();
            return byArray;
        }
        catch (Throwable throwable2) {
            Object var5_5 = null;
            or.release();
            throw throwable2;
        }
    }

    private static byte[] read(ObjectReader or, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader loader = or.open(blobId, 3);
        return loader.getCachedBytes(Integer.MAX_VALUE);
    }

    public BlobBasedConfig(Config base, Repository db, AnyObjectId treeish, String path2) throws FileNotFoundException, IOException, ConfigInvalidException {
        this(base, BlobBasedConfig.read(db, treeish, path2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] read(Repository db, AnyObjectId treeish, String path2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectReader or = db.newObjectReader();
        try {
            TreeWalk tree2 = TreeWalk.forPath(or, path2, BlobBasedConfig.asTree(or, treeish));
            if (tree2 == null) {
                throw new FileNotFoundException(MessageFormat.format(JGitText.get().entryNotFoundByPath, path2));
            }
            byte[] byArray = BlobBasedConfig.read(or, (AnyObjectId)tree2.getObjectId(0));
            Object var7_6 = null;
            or.release();
            return byArray;
        }
        catch (Throwable throwable2) {
            Object var7_7 = null;
            or.release();
            throw throwable2;
        }
    }

    private static AnyObjectId asTree(ObjectReader or, AnyObjectId treeish) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (treeish instanceof RevTree) {
            return treeish;
        }
        if (treeish instanceof RevCommit && ((RevCommit)treeish).getTree() != null) {
            return ((RevCommit)treeish).getTree();
        }
        return new RevWalk(or).parseTree(treeish).getId();
    }
}

