/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public class RepositoryCache {
    private static final RepositoryCache cache = new RepositoryCache();
    private final ConcurrentHashMap<Key, Reference<Repository>> cacheMap = new ConcurrentHashMap();
    private final Lock[] openLocks = new Lock[4];

    public static Repository open(Key location) throws IOException, RepositoryNotFoundException {
        return RepositoryCache.open(location, true);
    }

    public static Repository open(Key location, boolean mustExist) throws IOException {
        return cache.openRepository(location, mustExist);
    }

    public static void register(Repository db) {
        if (db.getDirectory() != null) {
            FileKey key = FileKey.exact(db.getDirectory(), db.getFS());
            cache.registerRepository(key, db);
        }
    }

    public static void close(Repository db) {
        if (db.getDirectory() != null) {
            FileKey key = FileKey.exact(db.getDirectory(), db.getFS());
            cache.unregisterRepository(key);
        }
    }

    public static void clear() {
        cache.clearAll();
    }

    private RepositoryCache() {
        for (int i = 0; i < this.openLocks.length; ++i) {
            this.openLocks[i] = new Lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Repository openRepository(Key location, boolean mustExist) throws IOException {
        Repository db;
        Reference<Repository> ref2 = this.cacheMap.get(location);
        Repository repository = db = ref2 != null ? ref2.get() : null;
        if (db == null) {
            Lock lock = this.lockFor(location);
            synchronized (lock) {
                ref2 = this.cacheMap.get(location);
                Repository repository2 = db = ref2 != null ? ref2.get() : null;
                if (db == null) {
                    db = location.open(mustExist);
                    ref2 = new SoftReference<Repository>(db);
                    this.cacheMap.put(location, ref2);
                }
            }
        }
        db.incrementOpen();
        return db;
    }

    private void registerRepository(Key location, Repository db) {
        Repository oldDb;
        db.incrementOpen();
        SoftReference<Repository> newRef = new SoftReference<Repository>(db);
        Reference oldRef = this.cacheMap.put(location, newRef);
        Repository repository = oldDb = oldRef != null ? (Repository)oldRef.get() : null;
        if (oldDb != null) {
            oldDb.close();
        }
    }

    private void unregisterRepository(Key location) {
        Repository oldDb;
        Reference<Repository> oldRef = this.cacheMap.remove(location);
        Repository repository = oldDb = oldRef != null ? oldRef.get() : null;
        if (oldDb != null) {
            oldDb.close();
        }
    }

    private void clearAll() {
        for (int stage = 0; stage < 2; ++stage) {
            Iterator<Map.Entry<Key, Reference<Repository>>> i = this.cacheMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Key, Reference<Repository>> e = i.next();
                Repository db = e.getValue().get();
                if (db != null) {
                    db.close();
                }
                i.remove();
            }
        }
    }

    private Lock lockFor(Key location) {
        return this.openLocks[(location.hashCode() >>> 1) % this.openLocks.length];
    }

    public static class FileKey
    implements Key {
        private final File path;
        private final FS fs;

        public static FileKey exact(File directory, FS fs) {
            return new FileKey(directory, fs);
        }

        public static FileKey lenient(File directory, FS fs) {
            File gitdir = FileKey.resolve(directory, fs);
            return new FileKey(gitdir != null ? gitdir : directory, fs);
        }

        protected FileKey(File directory, FS fs) {
            this.path = FileKey.canonical(directory);
            this.fs = fs;
        }

        private static File canonical(File path2) {
            try {
                return path2.getCanonicalFile();
            }
            catch (IOException e) {
                return path2.getAbsoluteFile();
            }
        }

        public final File getFile() {
            return this.path;
        }

        public Repository open(boolean mustExist) throws IOException {
            if (mustExist && !FileKey.isGitRepository(this.path, this.fs)) {
                throw new RepositoryNotFoundException(this.path);
            }
            return new FileRepository(this.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof FileKey && this.path.equals(((FileKey)o).path);
        }

        public String toString() {
            return this.path.toString();
        }

        public static boolean isGitRepository(File dir, FS fs) {
            return fs.resolve(dir, "objects").exists() && fs.resolve(dir, "refs").exists() && FileKey.isValidHead(new File(dir, "HEAD"));
        }

        private static boolean isValidHead(File head2) {
            String ref2 = FileKey.readFirstLine(head2);
            return ref2 != null && (ref2.startsWith("ref: refs/") || ObjectId.isId(ref2));
        }

        private static String readFirstLine(File head2) {
            try {
                byte[] buf = IO.readFully(head2, 4096);
                int n = buf.length;
                if (n == 0) {
                    return null;
                }
                if (buf[n - 1] == 10) {
                    --n;
                }
                return RawParseUtils.decode(buf, 0, n);
            }
            catch (IOException e) {
                return null;
            }
        }

        public static File resolve(File directory, FS fs) {
            if (FileKey.isGitRepository(directory, fs)) {
                return directory;
            }
            if (FileKey.isGitRepository(new File(directory, ".git"), fs)) {
                return new File(directory, ".git");
            }
            String name2 = directory.getName();
            File parent = directory.getParentFile();
            if (FileKey.isGitRepository(new File(parent, name2 + ".git"), fs)) {
                return new File(parent, name2 + ".git");
            }
            return null;
        }
    }

    public static interface Key {
        public Repository open(boolean var1) throws IOException, RepositoryNotFoundException;
    }

    private static class Lock {
        private Lock() {
        }
    }
}

