/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revwalk.RevFlag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlotRenderer<TLane extends PlotLane, TColor> {
    private static final int LANE_WIDTH = 14;
    private static final int LINE_WIDTH = 2;
    private static final int LEFT_PAD = 2;

    protected void paintCommit(PlotCommit<TLane> commit2, int h2) {
        int ix;
        int cx;
        int dotSize = AbstractPlotRenderer.computeDotSize(h2);
        TLane myLane = commit2.getLane();
        int myLaneX = AbstractPlotRenderer.laneC(myLane);
        TColor myColor = this.laneColor(myLane);
        int maxCenter = myLaneX;
        for (PlotLane passingLane : commit2.passingLanes) {
            int cx2 = AbstractPlotRenderer.laneC(passingLane);
            TColor c = this.laneColor(passingLane);
            this.drawLine(c, cx2, 0, cx2, h2, 2);
            maxCenter = Math.max(maxCenter, cx2);
        }
        int dotX = myLaneX - dotSize / 2 - 1;
        int dotY = (h2 - dotSize) / 2;
        int nParent = commit2.getParentCount();
        if (nParent > 0) {
            this.drawLine(myColor, myLaneX, h2, myLaneX, (h2 + dotSize) / 2, 2);
            for (int i = 0; i < commit2.mergingLanes.length; ++i) {
                PlotLane pLane = commit2.mergingLanes[i];
                TColor pColor = this.laneColor(pLane);
                cx = AbstractPlotRenderer.laneC(pLane);
                if (Math.abs(myLaneX - cx) > 14) {
                    ix = myLaneX < cx ? cx - 7 : cx + 7;
                    this.drawLine(pColor, myLaneX, h2 / 2, ix, h2 / 2, 2);
                    this.drawLine(pColor, ix, h2 / 2, cx, h2, 2);
                } else {
                    this.drawLine(pColor, myLaneX, h2 / 2, cx, h2, 2);
                }
                maxCenter = Math.max(maxCenter, cx);
            }
        }
        if (commit2.getChildCount() > 0) {
            for (int i = 0; i < commit2.forkingOffLanes.length; ++i) {
                PlotLane childLane = commit2.forkingOffLanes[i];
                TColor cColor = this.laneColor(childLane);
                cx = AbstractPlotRenderer.laneC(childLane);
                if (Math.abs(myLaneX - cx) > 14) {
                    ix = myLaneX < cx ? cx - 7 : cx + 7;
                    this.drawLine(cColor, myLaneX, h2 / 2, ix, h2 / 2, 2);
                    this.drawLine(cColor, ix, h2 / 2, cx, 0, 2);
                } else {
                    this.drawLine(cColor, myLaneX, h2 / 2, cx, 0, 2);
                }
                maxCenter = Math.max(maxCenter, cx);
            }
            int nonForkingChildren = commit2.getChildCount() - commit2.forkingOffLanes.length;
            if (nonForkingChildren > 0) {
                this.drawLine(myColor, myLaneX, 0, myLaneX, dotY, 2);
            }
        }
        if (commit2.has(RevFlag.UNINTERESTING)) {
            this.drawBoundaryDot(dotX, dotY, dotSize, dotSize);
        } else {
            this.drawCommitDot(dotX, dotY, dotSize, dotSize);
        }
        int textx = Math.max(maxCenter + 7, dotX + dotSize) + 8;
        int n = commit2.refs.length;
        for (int i = 0; i < n; ++i) {
            textx += this.drawLabel(textx + dotSize, h2 / 2, commit2.refs[i]);
        }
        String msg = commit2.getShortMessage();
        this.drawText(msg, textx + dotSize, h2);
    }

    protected abstract int drawLabel(int var1, int var2, Ref var3);

    private static int computeDotSize(int h2) {
        int d = (int)((float)Math.min(h2, 14) * 0.5f);
        d += d & 1;
        return d;
    }

    protected abstract TColor laneColor(TLane var1);

    protected abstract void drawLine(TColor var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract void drawCommitDot(int var1, int var2, int var3, int var4);

    protected abstract void drawBoundaryDot(int var1, int var2, int var3, int var4);

    protected abstract void drawText(String var1, int var2, int var3);

    private static int laneX(PlotLane myLane) {
        int p = myLane != null ? myLane.getPosition() : 0;
        return 2 + 14 * p;
    }

    private static int laneC(PlotLane myLane) {
        return AbstractPlotRenderer.laneX(myLane) + 7;
    }
}

